/*
 * Decompiled with CFR 0.152.
 */
package frame.options.simulation.create.links;

import frame.options.simulation.create.links.LinksListCellRenderer;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.SystemColor;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionListener;
import model.algorithms.linksMapping.LinksMappingAlgorithm;

public class LinksPanel
extends JPanel {
    private JList<LinksMappingAlgorithm> linksMappingAlgorithmsList;
    private JLabel errorLabel;

    public JList<LinksMappingAlgorithm> getLinksMappingAlgorithmsList() {
        return this.linksMappingAlgorithmsList;
    }

    public void setLinksMappingAlgorithmsList(JList<LinksMappingAlgorithm> linksMappingAlgorithmsList) {
        this.linksMappingAlgorithmsList = linksMappingAlgorithmsList;
    }

    public JLabel getErrorLabel() {
        return this.errorLabel;
    }

    public void setErrorLabel(JLabel errorLabel) {
        this.errorLabel = errorLabel;
    }

    public LinksPanel(List<LinksMappingAlgorithm> linksMappingAlgorithms) {
        DefaultListModel<LinksMappingAlgorithm> linksMappingAlgorithmsListModel = new DefaultListModel<LinksMappingAlgorithm>();
        for (LinksMappingAlgorithm linksMappingAlgorithm : linksMappingAlgorithms) {
            linksMappingAlgorithmsListModel.addElement(linksMappingAlgorithm);
        }
        this.setLinksMappingAlgorithmsList(new JList<LinksMappingAlgorithm>(linksMappingAlgorithmsListModel));
        this.getLinksMappingAlgorithmsList().setName("availableList");
        this.getLinksMappingAlgorithmsList().setCellRenderer(new LinksListCellRenderer());
        this.setLayout(new BorderLayout());
        this.add((Component)this.titlePanel(), "North");
        this.add((Component)this.contentPanel(), "Center");
        this.add((Component)this.errorPanel(), "South");
    }

    private JPanel titlePanel() {
        JLabel titleLabel = new JLabel("Virtual link mapping algorithm");
        titleLabel.setFont(new Font("MS Sans Serif", 1, 14));
        titleLabel.setBorder(new EmptyBorder(new Insets(10, 10, 10, 10)));
        titleLabel.setOpaque(true);
        JSeparator separator = new JSeparator();
        JPanel titlePanel = new JPanel();
        titlePanel.setLayout(new BorderLayout());
        titlePanel.setBackground(Color.gray);
        titlePanel.add((Component)titleLabel, "Center");
        titlePanel.add((Component)separator, "South");
        return titlePanel;
    }

    private JPanel contentPanel() {
        JPanel panel = new JPanel();
        panel.setBorder(new EmptyBorder(new Insets(50, 50, 50, 50)));
        panel.add(this.availablePanel());
        return panel;
    }

    private JPanel availablePanel() {
        JLabel label = new JLabel("Available");
        label.setFont(new Font("MS Sans Serif", 1, 12));
        label.setAlignmentX(0.5f);
        JScrollPane availableScrollPane = new JScrollPane(this.getLinksMappingAlgorithmsList());
        availableScrollPane.setPreferredSize(new Dimension(200, 250));
        availableScrollPane.setBorder(BorderFactory.createLineBorder(SystemColor.activeCaption, 2));
        JPanel availablePanel = new JPanel();
        availablePanel.setLayout(new BoxLayout(availablePanel, 3));
        availablePanel.add(label);
        availablePanel.add(Box.createRigidArea(new Dimension(0, 5)));
        availablePanel.add(availableScrollPane);
        return availablePanel;
    }

    private JPanel errorPanel() {
        this.setErrorLabel(new JLabel(""));
        this.getErrorLabel().setForeground(Color.RED);
        JPanel errorPanel = new JPanel();
        errorPanel.add(this.getErrorLabel());
        return errorPanel;
    }

    public void addListeners(ListSelectionListener listSelectionListener) {
        this.getLinksMappingAlgorithmsList().addListSelectionListener(listSelectionListener);
    }

    public LinksMappingAlgorithm getSelectedLinksMappingAlgorithm() {
        if (this.getLinksMappingAlgorithmsList().getSelectedValuesList().size() != 1) {
            return null;
        }
        return this.getLinksMappingAlgorithmsList().getSelectedValue();
    }
}

