/*
 * Decompiled with CFR 0.152.
 */
package frame.options.simulation.create.links;

import com.nexes.wizard.WizardPanelDescriptor;
import frame.options.simulation.create.CreateSimulationWizard;
import frame.options.simulation.create.coordinated.CoordinatedDescriptor;
import frame.options.simulation.create.cost.CostDescriptor;
import frame.options.simulation.create.links.LinksPanel;
import ilog.concert.IloException;
import ilog.cplex.IloCplex;
import java.util.List;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import model.algorithms.linksMapping.LinksMappingAlgorithm;

public class LinksDescriptor
extends WizardPanelDescriptor
implements ListSelectionListener {
    public static final String IDENTIFIER = LinksDescriptor.class.getSimpleName();
    private LinksPanel linksPanel;

    public LinksPanel getLinksMappingPanel() {
        return this.linksPanel;
    }

    public void setLinksMappingPanel(LinksPanel linksPanel) {
        this.linksPanel = linksPanel;
    }

    public LinksDescriptor(List<LinksMappingAlgorithm> linksMappingAlgorithms) {
        this.setLinksMappingPanel(new LinksPanel(linksMappingAlgorithms));
        this.getLinksMappingPanel().addListeners(this);
        this.setPanelDescriptorIdentifier(IDENTIFIER);
        this.setPanelComponent(this.getLinksMappingPanel());
    }

    @Override
    public Object getBackPanelDescriptor() {
        return CoordinatedDescriptor.IDENTIFIER;
    }

    @Override
    public Object getNextPanelDescriptor() {
        return CostDescriptor.IDENTIFIER;
    }

    @Override
    public void aboutToDisplayPanel() {
        this.setNextFinishButton();
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        this.setNextFinishButton();
    }

    private void setNextFinishButton() {
        this.getLinksMappingPanel().getErrorLabel().setText("");
        this.getWizard().setNextFinishButtonEnabled(false);
        if (this.getLinksMappingPanel().getLinksMappingAlgorithmsList().getSelectedValuesList().size() == 1) {
            if (this.isCplexInstalled() || !this.isCplexInstalled() && !this.getLinksMappingPanel().getLinksMappingAlgorithmsList().getSelectedValuesList().get(0).getName().equals("Multi Commodity Flow")) {
                ((CreateSimulationWizard)this.getWizard()).setLinksMappingAlgorithm(this.getLinksMappingPanel().getSelectedLinksMappingAlgorithm());
                this.getWizard().setNextFinishButtonEnabled(true);
            } else {
                this.getLinksMappingPanel().getErrorLabel().setText("\"Multi Commodity Flow\" is not selectable because Cplex is not installed");
            }
        }
    }

    private boolean isCplexInstalled() {
        try {
            new IloCplex();
            return true;
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            return false;
        }
        catch (IloException e) {
            return false;
        }
    }
}

