/*
 * Decompiled with CFR 0.152.
 */
package frame.options.simulation.create.embedding;

import frame.options.simulation.create.embedding.EmbeddingListCellRenderer;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.SystemColor;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionListener;
import model.algorithms.embedding.EmbeddingAlgorithm;

public class EmbeddingPanel
extends JPanel {
    public static final String AVAILABLE_LIST = "AvailableList";
    private JList<EmbeddingAlgorithm> embeddingAlgorithmsList;

    public JList<EmbeddingAlgorithm> getEmbeddingAlgorithmsList() {
        return this.embeddingAlgorithmsList;
    }

    public void setEmbeddingAlgorithmsList(JList<EmbeddingAlgorithm> embeddingAlgorithmsList) {
        this.embeddingAlgorithmsList = embeddingAlgorithmsList;
    }

    public EmbeddingPanel(List<EmbeddingAlgorithm> embeddingAlgorithms) {
        DefaultListModel<EmbeddingAlgorithm> embeddingAlgorithmsListModel = new DefaultListModel<EmbeddingAlgorithm>();
        for (EmbeddingAlgorithm embeddingAlgorithm : embeddingAlgorithms) {
            embeddingAlgorithmsListModel.addElement(embeddingAlgorithm);
        }
        this.setEmbeddingAlgorithmsList(new JList<EmbeddingAlgorithm>(embeddingAlgorithmsListModel));
        this.getEmbeddingAlgorithmsList().setName(AVAILABLE_LIST);
        this.getEmbeddingAlgorithmsList().setCellRenderer(new EmbeddingListCellRenderer());
        this.setLayout(new BorderLayout());
        this.add((Component)this.titlePanel(), "North");
        this.add((Component)this.contentPanel(), "Center");
    }

    private JPanel titlePanel() {
        JLabel titleLabel = new JLabel("Virtual network embedding algorithm");
        titleLabel.setFont(new Font("MS Sans Serif", 1, 14));
        titleLabel.setBorder(new EmptyBorder(new Insets(10, 10, 10, 10)));
        titleLabel.setOpaque(true);
        JSeparator separator = new JSeparator();
        JPanel titlePanel = new JPanel();
        titlePanel.setLayout(new BorderLayout());
        titlePanel.setBackground(Color.gray);
        titlePanel.add((Component)titleLabel, "Center");
        titlePanel.add((Component)separator, "South");
        return titlePanel;
    }

    private JPanel contentPanel() {
        JPanel contentPanel = new JPanel();
        contentPanel.setBorder(new EmptyBorder(new Insets(50, 50, 50, 50)));
        contentPanel.add(this.availablePanel());
        return contentPanel;
    }

    private JPanel availablePanel() {
        JLabel availableLabel = new JLabel("Available");
        availableLabel.setFont(new Font("MS Sans Serif", 1, 12));
        availableLabel.setAlignmentX(0.5f);
        JScrollPane availableScrollPane = new JScrollPane(this.getEmbeddingAlgorithmsList());
        availableScrollPane.setPreferredSize(new Dimension(200, 250));
        availableScrollPane.setBorder(BorderFactory.createLineBorder(SystemColor.activeCaption, 2));
        JPanel availablePanel = new JPanel();
        availablePanel.setLayout(new BoxLayout(availablePanel, 3));
        availablePanel.add(availableLabel);
        availablePanel.add(Box.createRigidArea(new Dimension(0, 5)));
        availablePanel.add(availableScrollPane);
        return availablePanel;
    }

    public void addListeners(ListSelectionListener listSelectionListener) {
        this.getEmbeddingAlgorithmsList().addListSelectionListener(listSelectionListener);
    }

    public boolean isOnlyOneSelected() {
        return this.getEmbeddingAlgorithmsList().getSelectedValuesList().size() == 1;
    }

    public EmbeddingAlgorithm getSelectedEmbeddingAlgorithm() {
        if (this.getEmbeddingAlgorithmsList().getSelectedValuesList().size() != 1) {
            return null;
        }
        return this.getEmbeddingAlgorithmsList().getSelectedValue();
    }
}

