/*
 * Decompiled with CFR 0.152.
 */
package frame.options.simulation;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import model.algorithms.embedding.EmbeddingAlgorithm;
import model.algorithms.linksMapping.LinksMappingAlgorithm;
import model.algorithms.nodesMapping.Greedy;
import model.algorithms.nodesMapping.NodesMappingAlgorithm;
import model.algorithms.rounding.RoundingAlgorithm;
import model.algorithms.splitting.SplittingAlgorithm;
import model.components.links.link.SdnLink;
import model.components.links.link.VirtualLink;
import model.components.networks.sdn.SdnNetwork;
import model.components.networks.virtual.VirtualNetwork;
import model.components.nodes.node.sdn.SdnNode;
import model.components.nodes.node.virtual.VirtualMachine;
import model.components.nodes.node.virtual.VirtualNode;

public class Simulation {
    public static final String CANCELED_STATE = "Canceled";
    public static final String DONE_STATE = "Done";
    public static final String READY_STATE = "Ready";
    private String name;
    private String state;
    private List<SdnNetwork> sdnNetworks;
    private List<VirtualNetwork> virtualNetworks;
    private SplittingAlgorithm splittingAlgorithm;
    private NodesMappingAlgorithm nodesMappingAlgorithm;
    private EmbeddingAlgorithm embeddingAlgorithm;
    private RoundingAlgorithm roundingAlgorithm;
    private LinksMappingAlgorithm linksMappingAlgorithm;
    private int rejectedVirtualNetworksNumber;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public List<SdnNetwork> getSdnNetworks() {
        return this.sdnNetworks;
    }

    public void setSdnNetworks(List<SdnNetwork> sdnNetworks) {
        this.sdnNetworks = sdnNetworks;
    }

    public List<VirtualNetwork> getVirtualNetworks() {
        return this.virtualNetworks;
    }

    public void setVirtualNetworks(List<VirtualNetwork> virtualNetworks) {
        this.virtualNetworks = virtualNetworks;
    }

    public SplittingAlgorithm getSplittingAlgorithm() {
        return this.splittingAlgorithm;
    }

    public void setSplittingAlgorithm(SplittingAlgorithm splittingAlgorithm) {
        this.splittingAlgorithm = splittingAlgorithm;
    }

    public NodesMappingAlgorithm getNodesMappingAlgorithm() {
        return this.nodesMappingAlgorithm;
    }

    public void setNodesMappingAlgorithm(NodesMappingAlgorithm nodesMappingAlgorithm) {
        this.nodesMappingAlgorithm = nodesMappingAlgorithm;
    }

    public EmbeddingAlgorithm getEmbeddingAlgorithm() {
        return this.embeddingAlgorithm;
    }

    public void setEmbeddingAlgorithm(EmbeddingAlgorithm embeddingAlgorithm) {
        this.embeddingAlgorithm = embeddingAlgorithm;
    }

    public RoundingAlgorithm getRoundingAlgorithm() {
        return this.roundingAlgorithm;
    }

    public void setRoundingAlgorithm(RoundingAlgorithm roundingAlgorithm) {
        this.roundingAlgorithm = roundingAlgorithm;
    }

    public LinksMappingAlgorithm getLinksMappingAlgorithm() {
        return this.linksMappingAlgorithm;
    }

    public void setLinksMappingAlgorithm(LinksMappingAlgorithm linksMappingAlgorithm) {
        this.linksMappingAlgorithm = linksMappingAlgorithm;
    }

    public int getRejectedVirtualNetworksNumber() {
        return this.rejectedVirtualNetworksNumber;
    }

    public void setRejectedVirtualNetworksNumber(int rejectedVirtualNetworksNumber) {
        this.rejectedVirtualNetworksNumber = rejectedVirtualNetworksNumber;
    }

    public Simulation(List<SdnNetwork> sdnNetworks, List<VirtualNetwork> virtualNetworks, SplittingAlgorithm splittingAlgorithm, NodesMappingAlgorithm nodesMappingAlgorithm, EmbeddingAlgorithm embeddingAlgorithm, RoundingAlgorithm roundingAlgorithm, LinksMappingAlgorithm linksMappingAlgorithm) {
        this.setSdnNetworks(sdnNetworks);
        this.setVirtualNetworks(virtualNetworks);
        this.setSplittingAlgorithm(splittingAlgorithm);
        this.setNodesMappingAlgorithm(nodesMappingAlgorithm);
        this.setEmbeddingAlgorithm(embeddingAlgorithm);
        this.setRoundingAlgorithm(roundingAlgorithm);
        this.setLinksMappingAlgorithm(linksMappingAlgorithm);
        if (this.getSdnNetworks().size() > 1) {
            splittingAlgorithm.setSdnNetworks(sdnNetworks);
        }
        if (embeddingAlgorithm == null) {
            this.setName(String.valueOf(splittingAlgorithm.getName()) + "_" + nodesMappingAlgorithm.getName() + "_" + linksMappingAlgorithm.getName());
        } else {
            this.setName(String.valueOf(splittingAlgorithm.getName()) + "_" + embeddingAlgorithm.getName() + "_" + roundingAlgorithm.getName() + "_" + linksMappingAlgorithm.getName());
        }
        this.setState(READY_STATE);
    }

    public int run(int timeInstant) {
        this.networksReleasing(this.completedVirtualNetworks(timeInstant));
        List<VirtualNetwork> startingVirtualNetworks = this.startingVirtualNetworks(timeInstant);
        for (VirtualNetwork startingVirtualNetwork : startingVirtualNetworks) {
            LinkedHashMap<String, LinkedHashMap<VirtualNode, SdnNode>> nodesMappings = new LinkedHashMap<String, LinkedHashMap<VirtualNode, SdnNode>>();
            LinkedHashMap<String, int[][][][]> linksMappings = new LinkedHashMap<String, int[][][][]>();
            ArrayList<VirtualNetwork> virtualSubnetworks = new ArrayList();
            if (this.getSdnNetworks().size() == 1) {
                int i = 0;
                for (VirtualNode virtualNode : startingVirtualNetwork.getVirtualNodes()) {
                    virtualNode.setNumber(i++);
                }
                i = 0;
                for (VirtualLink virtualLink : startingVirtualNetwork.getVirtualLinks()) {
                    virtualLink.setNumber(i++);
                }
                startingVirtualNetwork.setSdnNetworkName(this.getSdnNetworks().get(0).getName());
                virtualSubnetworks.add(startingVirtualNetwork);
            } else {
                virtualSubnetworks = this.getSplittingAlgorithm().run(startingVirtualNetwork);
            }
            startingVirtualNetwork.setVirtualSubnetworks(virtualSubnetworks);
            if (virtualSubnetworks == null) {
                System.out.println("SplittingAlgorithm KO");
                startingVirtualNetwork.setDenied(true);
            } else {
                block3: for (SdnNetwork sdnNetwork : this.getSdnNetworks()) {
                    if (startingVirtualNetwork.isDenied()) break;
                    for (VirtualNetwork virtualSubnetwork : virtualSubnetworks) {
                        int[][][][] nArray;
                        LinkedHashMap<VirtualNode, SdnNode> nodesMapping;
                        if (!virtualSubnetwork.getSdnNetworkName().equals(sdnNetwork.getName())) continue;
                        if (virtualSubnetwork.getLinks().size() == 0 || virtualSubnetwork.getNodes().size() == 1) {
                            nodesMapping = new Greedy("Greedy").run(virtualSubnetwork, sdnNetwork);
                            if (nodesMapping != null) {
                                nodesMappings.put(sdnNetwork.getName(), nodesMapping);
                                continue;
                            }
                            if (nodesMapping != null) continue;
                            System.out.println("Greedy KO");
                            startingVirtualNetwork.setDenied(true);
                            continue block3;
                        }
                        if (virtualSubnetwork.getVirtualLinks().size() <= 0) continue;
                        nodesMapping = null;
                        int[][][][] nArray2 = null;
                        if (this.getEmbeddingAlgorithm() == null) {
                            nodesMapping = this.getNodesMappingAlgorithm().run(virtualSubnetwork, sdnNetwork);
                            if (nodesMapping == null) {
                                System.out.println("NodesMappingAlgorithm KO");
                                startingVirtualNetwork.setDenied(true);
                                continue block3;
                            }
                        } else if (this.getEmbeddingAlgorithm() != null) {
                            if (this.getEmbeddingAlgorithm().run(virtualSubnetwork, sdnNetwork)) {
                                nodesMapping = this.getRoundingAlgorithm().run(virtualSubnetwork, sdnNetwork, this.getEmbeddingAlgorithm().getXValues(), this.getEmbeddingAlgorithm().getFValues());
                                if (nodesMapping == null) {
                                    System.out.println("RoundingAlgorithm KO");
                                    startingVirtualNetwork.setDenied(true);
                                }
                            } else {
                                System.out.println("EmbeddingAlgorithm KO");
                                startingVirtualNetwork.setDenied(true);
                            }
                        }
                        if ((nArray = this.getLinksMappingAlgorithm().run(virtualSubnetwork, sdnNetwork, nodesMapping)) == null) {
                            System.out.println("LinksMappingAlgorithm KO");
                            startingVirtualNetwork.setDenied(true);
                            continue block3;
                        }
                        nodesMappings.put(sdnNetwork.getName(), nodesMapping);
                        linksMappings.put(sdnNetwork.getName(), nArray);
                    }
                }
            }
            if (!startingVirtualNetwork.isDenied()) {
                startingVirtualNetwork.setState("Accepted");
                startingVirtualNetwork.setChange(true);
                for (SdnNetwork sdnNetwork : this.getSdnNetworks()) {
                    for (VirtualNetwork virtualSubnetwork : virtualSubnetworks) {
                        if (!virtualSubnetwork.getSdnNetworkName().equals(sdnNetwork.getName())) continue;
                        virtualSubnetwork.setDenied(false);
                        if (virtualSubnetwork.getNodes().size() > 0) {
                            for (Map.Entry entry : nodesMappings.entrySet()) {
                                if (!virtualSubnetwork.getSdnNetworkName().equals(entry.getKey())) continue;
                                virtualSubnetwork.setVirtualNodesMapping((LinkedHashMap)entry.getValue());
                                this.nodesAllocating(virtualSubnetwork, sdnNetwork);
                                break;
                            }
                        }
                        if (virtualSubnetwork.getLinks().size() > 0) {
                            for (Map.Entry entry : linksMappings.entrySet()) {
                                if (!virtualSubnetwork.getSdnNetworkName().equals(entry.getKey())) continue;
                                virtualSubnetwork.setLinksMapping((int[][][][])entry.getValue());
                                this.linksAllocating(virtualSubnetwork, sdnNetwork);
                                break;
                            }
                        }
                        sdnNetwork.setChange(true);
                    }
                }
                continue;
            }
            startingVirtualNetwork.setState("Rejected");
            this.setRejectedVirtualNetworksNumber(this.getRejectedVirtualNetworksNumber() + 1);
        }
        return this.getRejectedVirtualNetworksNumber();
    }

    public int getSimulationEndingDate() {
        int simulationEndingDate = 0;
        for (VirtualNetwork virtualNetwork : this.getVirtualNetworks()) {
            if (virtualNetwork.getEndingDate() <= simulationEndingDate) continue;
            simulationEndingDate = virtualNetwork.getEndingDate();
        }
        return simulationEndingDate;
    }

    public List<VirtualNetwork> startingVirtualNetworks(int timeInstant) {
        ArrayList<VirtualNetwork> virtualNetworks = new ArrayList<VirtualNetwork>();
        for (VirtualNetwork virtualNetwork : this.getVirtualNetworks()) {
            if (virtualNetwork.getStartingDate() != timeInstant) continue;
            virtualNetworks.add(virtualNetwork);
        }
        return virtualNetworks;
    }

    private void nodesAllocating(VirtualNetwork virtualNetwork, SdnNetwork sdnNetwork) {
        for (SdnNode sdnNode : sdnNetwork.getSdnNodes()) {
            for (Map.Entry<VirtualNode, SdnNode> nodesMapping : virtualNetwork.getNodesMapping().entrySet()) {
                VirtualNode mappedVirtualNode = nodesMapping.getKey();
                SdnNode mappedSdnNode = nodesMapping.getValue();
                if (sdnNode.getNumber() != mappedSdnNode.getNumber()) continue;
                sdnNode.setAvailableCPU(sdnNode.getAvailableCPU() - mappedVirtualNode.getCPU());
                sdnNode.setAvailableRAM(sdnNode.getAvailableRAM() - mappedVirtualNode.getRAM());
                if (mappedVirtualNode.getType().equals("Server")) {
                    sdnNode.setAvailableStorage(sdnNode.getAvailableStorage() - mappedVirtualNode.getStorage());
                }
                sdnNode.setAvailableVirtualNodesNumber(sdnNode.getAvailableVirtualNodesNumber() - 1);
                mappedVirtualNode.setNumber(mappedVirtualNode.getInitialNumber());
                sdnNode.add(mappedVirtualNode);
                mappedVirtualNode.setSdnNode(sdnNode);
                mappedVirtualNode.setCPUprice(sdnNetwork.getCPUprice());
                mappedVirtualNode.setRAMprice(sdnNetwork.getRAMprice());
                if (!mappedVirtualNode.getType().equals("Server")) continue;
                mappedVirtualNode.setStoragePrice(sdnNetwork.getStoragePrice());
            }
        }
    }

    private void linksAllocating(VirtualNetwork virtualNetwork, SdnNetwork sdnNetwork) {
        int[][][][] linksMapping = virtualNetwork.getLinksMapping();
        if (linksMapping != null) {
            int k = 0;
            while (k < virtualNetwork.getVirtualLinks().size()) {
                int i = 0;
                while (i < sdnNetwork.getNodes().size()) {
                    int j = 0;
                    while (j < sdnNetwork.getNodes().size()) {
                        int backupFlag = 0;
                        while (backupFlag < 2) {
                            if (linksMapping[k][i][j][backupFlag] != 0) {
                                for (VirtualLink virtualLink : virtualNetwork.getVirtualLinks()) {
                                    if (virtualLink.getNumber() != k) continue;
                                    for (SdnLink sdnLink : sdnNetwork.getSdnLinks()) {
                                        if ((i != sdnLink.getFirstNode().getNumber() || j != sdnLink.getSecondNode().getNumber()) && (i != sdnLink.getSecondNode().getNumber() || j != sdnLink.getFirstNode().getNumber())) continue;
                                        int bw = linksMapping[k][i][j][backupFlag];
                                        sdnLink.put(virtualLink, bw, backupFlag);
                                        virtualLink.put(sdnLink, bw, backupFlag);
                                        virtualLink.setBWprice(sdnNetwork.getBWprice());
                                    }
                                }
                            }
                            ++backupFlag;
                        }
                        ++j;
                    }
                    ++i;
                }
                ++k;
            }
        }
    }

    public List<VirtualNetwork> completedVirtualNetworks(int timeInstant) {
        ArrayList<VirtualNetwork> virtualNetworks = new ArrayList<VirtualNetwork>();
        for (VirtualNetwork virtualNetwork : this.getVirtualNetworks()) {
            if (virtualNetwork.getEndingDate() != timeInstant) continue;
            virtualNetworks.add(virtualNetwork);
        }
        return virtualNetworks;
    }

    private void networksReleasing(List<VirtualNetwork> virtualNetworks) {
        for (VirtualNetwork virtualNetwork : virtualNetworks) {
            if (!virtualNetwork.getState().equals("Accepted")) continue;
            virtualNetwork.setChange(true);
            if (virtualNetwork.getVirtualSubnetworks() == null) continue;
            for (VirtualNetwork virtualSubnetwork : virtualNetwork.getVirtualSubnetworks()) {
                for (SdnNetwork sdnNetwork : this.getSdnNetworks()) {
                    if (!virtualSubnetwork.getSdnNetworkName().equals(sdnNetwork.getName()) || virtualSubnetwork.isDenied()) continue;
                    sdnNetwork.setChange(true);
                    this.nodesReleasing(virtualSubnetwork, sdnNetwork);
                    this.linksReleasing(virtualSubnetwork, sdnNetwork);
                }
            }
        }
    }

    private void nodesReleasing(VirtualNetwork virtualNetwork, SdnNetwork sdnNetwork) {
        LinkedHashMap<VirtualNode, SdnNode> nodesMapping = virtualNetwork.getNodesMapping();
        for (SdnNode sdnNode : sdnNetwork.getSdnNodes()) {
            if (nodesMapping == null) continue;
            for (Map.Entry<VirtualNode, SdnNode> nodeMapping : nodesMapping.entrySet()) {
                VirtualNode mappedVirtualNode = nodeMapping.getKey();
                SdnNode mappedSdnNode = nodeMapping.getValue();
                if (sdnNode.getNumber() != mappedSdnNode.getNumber()) continue;
                sdnNode.setAvailableCPU(sdnNode.getAvailableCPU() + mappedVirtualNode.getCPU());
                sdnNode.setAvailableRAM(sdnNode.getAvailableRAM() + mappedVirtualNode.getRAM());
                if (mappedVirtualNode instanceof VirtualMachine) {
                    sdnNode.setAvailableStorage(sdnNode.getAvailableStorage() + mappedVirtualNode.getStorage());
                }
                sdnNode.setAvailableVirtualNodesNumber(sdnNode.getAvailableVirtualNodesNumber() + 1);
                sdnNode.remove(mappedVirtualNode);
                mappedVirtualNode.setSdnNode(null);
                mappedVirtualNode.setCPUprice(0);
                mappedVirtualNode.setRAMprice(0);
                if (!mappedVirtualNode.getType().equals("Server")) continue;
                mappedVirtualNode.setStoragePrice(0);
            }
        }
    }

    private void linksReleasing(VirtualNetwork virtualNetwork, SdnNetwork sdnNetwork) {
        int[][][][] linksMapping = virtualNetwork.getLinksMapping();
        if (linksMapping != null) {
            int k = 0;
            while (k < virtualNetwork.getVirtualLinks().size()) {
                int i = 0;
                while (i < sdnNetwork.getNodes().size()) {
                    int j = 0;
                    while (j < sdnNetwork.getNodes().size()) {
                        int a = 0;
                        while (a < 2) {
                            if (linksMapping[k][i][j][a] != 0) {
                                for (VirtualLink virtualLink : virtualNetwork.getVirtualLinks()) {
                                    if (virtualLink.getNumber() != k) continue;
                                    for (SdnLink sdnLink : sdnNetwork.getSdnLinks()) {
                                        if ((i != sdnLink.getFirstNode().getNumber() || j != sdnLink.getSecondNode().getNumber()) && (i != sdnLink.getSecondNode().getNumber() || j != sdnLink.getFirstNode().getNumber())) continue;
                                        sdnLink.remove(virtualLink);
                                        virtualLink.remove(sdnLink);
                                        virtualLink.setBWprice(0);
                                    }
                                }
                            }
                            ++a;
                        }
                        ++j;
                    }
                    ++i;
                }
                ++k;
            }
        }
    }
}

