/*
 * Decompiled with CFR 0.152.
 */
package frame.options.sdn.create;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentListener;

public class CreateSdnSelectPanel
extends JPanel {
    private JLabel networksNumberLabel;
    private JTextField networksNumberTextField;
    private JLabel routersNumberLabel;
    private JTextField minRoutersNumberTextField;
    private JTextField maxRoutersNumberTextField;
    private JLabel switchesNumberLabel;
    private JTextField minSwitchesNumberTextField;
    private JTextField maxSwitchesNumberTextField;
    private JLabel serversNumberLabel;
    private JTextField minServersNumberTextField;
    private JTextField maxServersNumberTextField;
    private JLabel osLabel;
    private JTextField linuxPercentageTextField;
    private JTextField windowsPercentageTextField;
    private JTextField solarisPercentageTextField;
    private JTextField androidPercentageTextField;
    private JLabel cpuLabel;
    private JTextField minCPUtextField;
    private JTextField maxCPUtextField;
    private JLabel cpuPriceLabel;
    private JTextField minCPUpriceTextField;
    private JTextField maxCPUpriceTextField;
    private JLabel ramLabel;
    private JTextField minRAMtextField;
    private JTextField maxRAMtextField;
    private JLabel ramPriceLabel;
    private JTextField minRAMpriceTextField;
    private JTextField maxRAMpriceTextField;
    private JLabel storageLabel;
    private JTextField minStorageTextField;
    private JTextField maxStorageTextField;
    private JLabel storagePriceLabel;
    private JTextField minStoragePriceTextField;
    private JTextField maxStoragePriceTextField;
    private JLabel maxVirtualNodesNumberLabel;
    private JTextField maxVirtualNodesNumberTextField;
    private JLabel bwLabel;
    private JTextField minBWtextField;
    private JTextField maxBWtextField;
    private JLabel bwPriceLabel;
    private JTextField minBWpriceTextField;
    private JTextField maxBWpriceTextField;
    private JLabel distanceLabel;
    private JTextField minDistanceTextField;
    private JTextField maxDistanceTextField;
    private JLabel informationLabel;

    public JLabel getNetworksNumberLabel() {
        return this.networksNumberLabel;
    }

    public void setNetworksNumberLabel(JLabel networksNumberLabel) {
        this.networksNumberLabel = networksNumberLabel;
    }

    public JTextField getNetworksNumberTextField() {
        return this.networksNumberTextField;
    }

    public void setNetworksNumberTextField(JTextField networksNumberTextField) {
        this.networksNumberTextField = networksNumberTextField;
    }

    public JLabel getRoutersNumberLabel() {
        return this.routersNumberLabel;
    }

    public void setRoutersNumberLabel(JLabel routersNumberLabel) {
        this.routersNumberLabel = routersNumberLabel;
    }

    public JTextField getMinRoutersNumberTextField() {
        return this.minRoutersNumberTextField;
    }

    public void setMinRoutersNumberTextField(JTextField minRoutersNumberTextField) {
        this.minRoutersNumberTextField = minRoutersNumberTextField;
    }

    public JTextField getMaxRoutersNumberTextField() {
        return this.maxRoutersNumberTextField;
    }

    public void setMaxRoutersNumberTextField(JTextField maxRoutersNumberTextField) {
        this.maxRoutersNumberTextField = maxRoutersNumberTextField;
    }

    public JLabel getSwitchesNumberLabel() {
        return this.switchesNumberLabel;
    }

    public void setSwitchesNumberLabel(JLabel switchesNumberLabel) {
        this.switchesNumberLabel = switchesNumberLabel;
    }

    public JTextField getMinSwitchesNumberTextField() {
        return this.minSwitchesNumberTextField;
    }

    public void setMinSwitchesNumberTextField(JTextField minSwitchesNumberTextField) {
        this.minSwitchesNumberTextField = minSwitchesNumberTextField;
    }

    public JTextField getMaxSwitchesNumberTextField() {
        return this.maxSwitchesNumberTextField;
    }

    public void setMaxSwitchesNumberTextField(JTextField maxSwitchesNumberTextField) {
        this.maxSwitchesNumberTextField = maxSwitchesNumberTextField;
    }

    public JLabel getServersNumberLabel() {
        return this.serversNumberLabel;
    }

    public void setServersNumberLabel(JLabel serversNumberLabel) {
        this.serversNumberLabel = serversNumberLabel;
    }

    public JTextField getMinServersNumberTextField() {
        return this.minServersNumberTextField;
    }

    public void setMinServersNumberTextField(JTextField minServersNumberTextField) {
        this.minServersNumberTextField = minServersNumberTextField;
    }

    public JTextField getMaxServersNumberTextField() {
        return this.maxServersNumberTextField;
    }

    public void setMaxServersNumberTextField(JTextField maxServersNumberTextField) {
        this.maxServersNumberTextField = maxServersNumberTextField;
    }

    public JLabel getOSlabel() {
        return this.osLabel;
    }

    public void setOSlabel(JLabel osLabel) {
        this.osLabel = osLabel;
    }

    public JTextField getLinuxPercentageTextField() {
        return this.linuxPercentageTextField;
    }

    public void setLinuxPercentageTextField(JTextField linuxPercentageTextField) {
        this.linuxPercentageTextField = linuxPercentageTextField;
    }

    public JTextField getWindowsPercentageTextField() {
        return this.windowsPercentageTextField;
    }

    public void setWindowsPercentageTextField(JTextField windowsPercentageTextField) {
        this.windowsPercentageTextField = windowsPercentageTextField;
    }

    public JTextField getSolarisPercentageTextField() {
        return this.solarisPercentageTextField;
    }

    public void setSolarisPercentageTextField(JTextField solarisPercentageTextField) {
        this.solarisPercentageTextField = solarisPercentageTextField;
    }

    public JTextField getAndroidPercentageTextField() {
        return this.androidPercentageTextField;
    }

    public void getAndroidPercentageTextField(JTextField androidPercentageTextField) {
        this.androidPercentageTextField = androidPercentageTextField;
    }

    public JLabel getCPUlabel() {
        return this.cpuLabel;
    }

    public void setCPUlabel(JLabel cpuLabel) {
        this.cpuLabel = cpuLabel;
    }

    public JTextField getMinCPUtextField() {
        return this.minCPUtextField;
    }

    public void setMinCPUtextField(JTextField minCPUtextField) {
        this.minCPUtextField = minCPUtextField;
    }

    public JTextField getMaxCPUtextField() {
        return this.maxCPUtextField;
    }

    public void setMaxCPUtextField(JTextField maxCPUtextField) {
        this.maxCPUtextField = maxCPUtextField;
    }

    public JLabel getCPUpriceLabel() {
        return this.cpuPriceLabel;
    }

    public void setCPUpriceLabel(JLabel cpuPriceLabel) {
        this.cpuPriceLabel = cpuPriceLabel;
    }

    public JTextField getMinCPUpriceTextField() {
        return this.minCPUpriceTextField;
    }

    public void setMinCPUpriceTextField(JTextField minCPUpriceTextField) {
        this.minCPUpriceTextField = minCPUpriceTextField;
    }

    public JTextField getMaxCPUpriceTextField() {
        return this.maxCPUpriceTextField;
    }

    public void setMaxCPUpriceTextField(JTextField maxCPUpriceTextField) {
        this.maxCPUpriceTextField = maxCPUpriceTextField;
    }

    public JLabel getRAMlabel() {
        return this.ramLabel;
    }

    public void setRAMlabel(JLabel ramLabel) {
        this.ramLabel = ramLabel;
    }

    public JTextField getMinRAMtextField() {
        return this.minRAMtextField;
    }

    public void setMinRAMtextField(JTextField minRAMtextField) {
        this.minRAMtextField = minRAMtextField;
    }

    public JTextField getMaxRAMtextField() {
        return this.maxRAMtextField;
    }

    public void setMaxRAMtextField(JTextField maxRAMtextField) {
        this.maxRAMtextField = maxRAMtextField;
    }

    public JLabel getRAMpriceLabel() {
        return this.ramPriceLabel;
    }

    public void setRAMpriceLabel(JLabel ramPriceLabel) {
        this.ramPriceLabel = ramPriceLabel;
    }

    public JTextField getMinRAMpriceTextField() {
        return this.minRAMpriceTextField;
    }

    public void setMinRAMpriceTextField(JTextField minRAMpriceTextField) {
        this.minRAMpriceTextField = minRAMpriceTextField;
    }

    public JTextField getMaxRAMpriceTextField() {
        return this.maxRAMpriceTextField;
    }

    public void setMaxRAMpriceTextField(JTextField maxRAMpriceTextField) {
        this.maxRAMpriceTextField = maxRAMpriceTextField;
    }

    public JLabel getStorageLabel() {
        return this.storageLabel;
    }

    public void setStorageLabel(JLabel storageLabel) {
        this.storageLabel = storageLabel;
    }

    public JTextField getMinStorageTextField() {
        return this.minStorageTextField;
    }

    public void setMinStorageTextField(JTextField minStorageTextField) {
        this.minStorageTextField = minStorageTextField;
    }

    public JTextField getMaxStorageTextField() {
        return this.maxStorageTextField;
    }

    public void setMaxStorageTextField(JTextField maxStorageTextField) {
        this.maxStorageTextField = maxStorageTextField;
    }

    public JLabel getStoragePriceLabel() {
        return this.storagePriceLabel;
    }

    public void setStoragePriceLabel(JLabel storagePriceLabel) {
        this.storagePriceLabel = storagePriceLabel;
    }

    public JTextField getMinStoragePriceTextField() {
        return this.minStoragePriceTextField;
    }

    public void setMinStoragePriceTextField(JTextField minStoragePriceTextField) {
        this.minStoragePriceTextField = minStoragePriceTextField;
    }

    public JTextField getMaxStoragePriceTextField() {
        return this.maxStoragePriceTextField;
    }

    public void setMaxStoragePriceTextField(JTextField maxStoragePriceTextField) {
        this.maxStoragePriceTextField = maxStoragePriceTextField;
    }

    public JLabel getMaxVirtualNodesNumberLabel() {
        return this.maxVirtualNodesNumberLabel;
    }

    public void setMaxVirtualNodesNumberLabel(JLabel maxVirtualNodesNumberLabel) {
        this.maxVirtualNodesNumberLabel = maxVirtualNodesNumberLabel;
    }

    public JTextField getMaxVirtualNodesNumberTextField() {
        return this.maxVirtualNodesNumberTextField;
    }

    public void setMaxVirtualNodesNumberTextField(JTextField maxVirtualNodesNumberTextField) {
        this.maxVirtualNodesNumberTextField = maxVirtualNodesNumberTextField;
    }

    public JLabel getBWlabel() {
        return this.bwLabel;
    }

    public void setBWlabel(JLabel bwLabel) {
        this.bwLabel = bwLabel;
    }

    public JTextField getMinBWtextField() {
        return this.minBWtextField;
    }

    public void setMinBWtextField(JTextField minBWtextField) {
        this.minBWtextField = minBWtextField;
    }

    public JTextField getMaxBWtextField() {
        return this.maxBWtextField;
    }

    public void setMaxBWtextField(JTextField maxBWtextField) {
        this.maxBWtextField = maxBWtextField;
    }

    public JLabel getBWpriceLabel() {
        return this.bwPriceLabel;
    }

    public void setBWpriceLabel(JLabel bwPriceLabel) {
        this.bwPriceLabel = bwPriceLabel;
    }

    public JTextField getMinBWpriceTextField() {
        return this.minBWpriceTextField;
    }

    public void setMinBWpriceTextField(JTextField minBWpriceTextField) {
        this.minBWpriceTextField = minBWpriceTextField;
    }

    public JTextField getMaxBWpriceTextField() {
        return this.maxBWpriceTextField;
    }

    public void setMaxBWpriceTextField(JTextField maxBWpriceTextField) {
        this.maxBWpriceTextField = maxBWpriceTextField;
    }

    public JLabel getDistanceLabel() {
        return this.distanceLabel;
    }

    public void setDistanceLabel(JLabel distanceLabel) {
        this.distanceLabel = distanceLabel;
    }

    public JTextField getMinDistanceTextField() {
        return this.minDistanceTextField;
    }

    public void setMinDistanceTextField(JTextField minDistanceTextField) {
        this.minDistanceTextField = minDistanceTextField;
    }

    public JTextField getMaxDistanceTextField() {
        return this.maxDistanceTextField;
    }

    public void setMaxDistanceTextField(JTextField maxDistanceTextField) {
        this.maxDistanceTextField = maxDistanceTextField;
    }

    public JLabel getInformationLabel() {
        return this.informationLabel;
    }

    public void setInformationLabel(JLabel informationLabel) {
        this.informationLabel = informationLabel;
    }

    public CreateSdnSelectPanel() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.titlePanel(), "North");
        this.add((Component)this.contentPanel(), "Center");
    }

    private JPanel titlePanel() {
        JLabel titleLabel = new JLabel("Random SDN networks");
        titleLabel.setFont(new Font("MS Sans Serif", 1, 14));
        titleLabel.setBorder(new EmptyBorder(new Insets(10, 10, 10, 10)));
        titleLabel.setOpaque(true);
        JPanel titlePanel = new JPanel();
        titlePanel.setLayout(new BorderLayout());
        titlePanel.setBackground(Color.gray);
        titlePanel.add((Component)titleLabel, "Center");
        titlePanel.add((Component)new JSeparator(), "South");
        return titlePanel;
    }

    private JPanel contentPanel() {
        JPanel informationPanel = this.informationPanel();
        JPanel networksPanel = this.networksPanel();
        JPanel nodesPanel = this.nodesPanel();
        JPanel nodePanel = this.nodePanel();
        JPanel linkPanel = this.linkPanel();
        JPanel contentPanel = new JPanel();
        GroupLayout groupLayout = new GroupLayout(contentPanel);
        groupLayout.setAutoCreateGaps(true);
        groupLayout.setAutoCreateContainerGaps(true);
        groupLayout.setHorizontalGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup().addComponent(informationPanel).addComponent(networksPanel).addComponent(nodesPanel).addComponent(nodePanel).addComponent(linkPanel)));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup().addGroup(groupLayout.createSequentialGroup().addComponent(informationPanel).addComponent(networksPanel).addComponent(nodesPanel).addComponent(nodePanel).addComponent(linkPanel)));
        contentPanel.setLayout(groupLayout);
        return contentPanel;
    }

    private JPanel informationPanel() {
        this.setInformationLabel(new JLabel());
        JPanel informationPanel = new JPanel();
        informationPanel.add(this.getInformationLabel());
        return informationPanel;
    }

    private JPanel networksPanel() {
        TitledBorder titledBorder = BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.black), "<html><b>SDN NETWORKS</b></html>");
        titledBorder.setTitleJustification(2);
        JPanel networksPanel = new JPanel();
        networksPanel.setLayout(new GridLayout(0, 1));
        networksPanel.setBorder(titledBorder);
        networksPanel.add(this.networksNumberPanel());
        return networksPanel;
    }

    private JPanel networksNumberPanel() {
        this.setNetworksNumberLabel(new JLabel("<html><b>Networks number:</b></html>"));
        this.setNetworksNumberTextField(new JTextField(Integer.toString(5)));
        this.getNetworksNumberTextField().setPreferredSize(new Dimension(25, 20));
        this.getNetworksNumberTextField().setHorizontalAlignment(0);
        JPanel networksNumberPanel = new JPanel(new FlowLayout(1));
        networksNumberPanel.add(this.getNetworksNumberLabel());
        networksNumberPanel.add(this.getNetworksNumberTextField());
        return networksNumberPanel;
    }

    private JPanel nodesPanel() {
        TitledBorder titledBorder = BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.black), "<html><b>SDN NODES</b></html>");
        titledBorder.setTitleJustification(2);
        JPanel nodesPanel = new JPanel();
        nodesPanel.setLayout(new GridLayout(0, 1));
        nodesPanel.setBorder(titledBorder);
        nodesPanel.add(this.routersNumberRangePanel());
        nodesPanel.add(this.switchesNumberRangePanel());
        nodesPanel.add(this.serversNumberRangePanel());
        nodesPanel.add(this.osPercentagesPanel());
        return nodesPanel;
    }

    private JPanel routersNumberRangePanel() {
        this.setRoutersNumberLabel(new JLabel("<html><b>Routers number:</b></html>"));
        this.setMinRoutersNumberTextField(new JTextField(Integer.toString(1)));
        this.getMinRoutersNumberTextField().setPreferredSize(new Dimension(25, 20));
        this.getMinRoutersNumberTextField().setHorizontalAlignment(0);
        this.setMaxRoutersNumberTextField(new JTextField(Integer.toString(5)));
        this.getMaxRoutersNumberTextField().setPreferredSize(new Dimension(25, 20));
        this.getMaxRoutersNumberTextField().setHorizontalAlignment(0);
        JPanel routersNumberRangePanel = new JPanel(new FlowLayout(1));
        routersNumberRangePanel.add(this.getRoutersNumberLabel());
        routersNumberRangePanel.add(new JLabel("Between"));
        routersNumberRangePanel.add(this.getMinRoutersNumberTextField());
        routersNumberRangePanel.add(new JLabel("and"));
        routersNumberRangePanel.add(this.getMaxRoutersNumberTextField());
        return routersNumberRangePanel;
    }

    private JPanel switchesNumberRangePanel() {
        this.setSwitchesNumberLabel(new JLabel("<html><b>Switches number:</b></html>"));
        this.setMinSwitchesNumberTextField(new JTextField(Integer.toString(3)));
        this.getMinSwitchesNumberTextField().setPreferredSize(new Dimension(25, 20));
        this.getMinSwitchesNumberTextField().setHorizontalAlignment(0);
        this.setMaxSwitchesNumberTextField(new JTextField(Integer.toString(10)));
        this.getMaxSwitchesNumberTextField().setPreferredSize(new Dimension(25, 20));
        this.getMaxSwitchesNumberTextField().setHorizontalAlignment(0);
        JPanel switchesNumberRangePanel = new JPanel(new FlowLayout(1));
        switchesNumberRangePanel.add(this.getSwitchesNumberLabel());
        switchesNumberRangePanel.add(new JLabel("Between"));
        switchesNumberRangePanel.add(this.getMinSwitchesNumberTextField());
        switchesNumberRangePanel.add(new JLabel("and"));
        switchesNumberRangePanel.add(this.getMaxSwitchesNumberTextField());
        return switchesNumberRangePanel;
    }

    private JPanel serversNumberRangePanel() {
        this.setServersNumberLabel(new JLabel("<html><b>Servers number:</b></html>"));
        this.setMinServersNumberTextField(new JTextField(Integer.toString(3)));
        this.getMinServersNumberTextField().setPreferredSize(new Dimension(25, 20));
        this.getMinServersNumberTextField().setHorizontalAlignment(0);
        this.setMaxServersNumberTextField(new JTextField(Integer.toString(10)));
        this.getMaxServersNumberTextField().setPreferredSize(new Dimension(25, 20));
        this.getMaxServersNumberTextField().setHorizontalAlignment(0);
        JPanel serversNumberRangePanel = new JPanel(new FlowLayout(1));
        serversNumberRangePanel.add(this.getServersNumberLabel());
        serversNumberRangePanel.add(new JLabel("Between"));
        serversNumberRangePanel.add(this.getMinServersNumberTextField());
        serversNumberRangePanel.add(new JLabel("and"));
        serversNumberRangePanel.add(this.getMaxServersNumberTextField());
        return serversNumberRangePanel;
    }

    private JPanel osPercentagesPanel() {
        this.setOSlabel(new JLabel("<html><b>Operating systems %:</b></html>"));
        this.setLinuxPercentageTextField(new JTextField(Integer.toString(100)));
        this.getLinuxPercentageTextField().setPreferredSize(new Dimension(25, 20));
        this.getLinuxPercentageTextField().setHorizontalAlignment(0);
        this.setWindowsPercentageTextField(new JTextField(Integer.toString(0)));
        this.getWindowsPercentageTextField().setPreferredSize(new Dimension(25, 20));
        this.getWindowsPercentageTextField().setHorizontalAlignment(0);
        this.setSolarisPercentageTextField(new JTextField(Integer.toString(0)));
        this.getSolarisPercentageTextField().setPreferredSize(new Dimension(25, 20));
        this.getSolarisPercentageTextField().setHorizontalAlignment(0);
        this.getAndroidPercentageTextField(new JTextField(Integer.toString(0)));
        this.getAndroidPercentageTextField().setPreferredSize(new Dimension(25, 20));
        this.getAndroidPercentageTextField().setHorizontalAlignment(0);
        JPanel osPercentagePanel = new JPanel(new FlowLayout(1));
        osPercentagePanel.add(this.getOSlabel());
        osPercentagePanel.add(new JLabel("Linux:"));
        osPercentagePanel.add(this.getLinuxPercentageTextField());
        osPercentagePanel.add(new JLabel("Windows:"));
        osPercentagePanel.add(this.getWindowsPercentageTextField());
        osPercentagePanel.add(new JLabel("Solaris:"));
        osPercentagePanel.add(this.getSolarisPercentageTextField());
        osPercentagePanel.add(new JLabel("Android:"));
        osPercentagePanel.add(this.getAndroidPercentageTextField());
        return osPercentagePanel;
    }

    private JPanel nodePanel() {
        TitledBorder titledBorder = BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.black), "<html><b>SDN NODE</b></html>");
        titledBorder.setTitleJustification(2);
        JPanel nodePanel = new JPanel();
        nodePanel.setLayout(new GridLayout(0, 1));
        nodePanel.setBorder(titledBorder);
        nodePanel.add(this.cpuPanel());
        nodePanel.add(this.ramPanel());
        nodePanel.add(this.storagePanel());
        nodePanel.add(this.maxVirtualNodesNumberPanel());
        return nodePanel;
    }

    private JPanel cpuPanel() {
        this.setCPUlabel(new JLabel("<html><b>CPU:</b></html>"));
        this.setMinCPUtextField(new JTextField(Integer.toString(50)));
        this.getMinCPUtextField().setPreferredSize(new Dimension(25, 20));
        this.getMinCPUtextField().setHorizontalAlignment(0);
        this.setMaxCPUtextField(new JTextField(Integer.toString(100)));
        this.getMaxCPUtextField().setPreferredSize(new Dimension(25, 20));
        this.getMaxCPUtextField().setHorizontalAlignment(0);
        this.setCPUpriceLabel(new JLabel("<html><b>Unit price:</b></html>"));
        this.setMinCPUpriceTextField(new JTextField(Integer.toString(50)));
        this.getMinCPUpriceTextField().setPreferredSize(new Dimension(25, 20));
        this.getMinCPUpriceTextField().setHorizontalAlignment(0);
        this.setMaxCPUpriceTextField(new JTextField(Integer.toString(100)));
        this.getMaxCPUpriceTextField().setPreferredSize(new Dimension(25, 20));
        this.getMaxCPUpriceTextField().setHorizontalAlignment(0);
        JPanel cpuPanel = new JPanel(new FlowLayout(1));
        cpuPanel.add(this.getCPUlabel());
        cpuPanel.add(new JLabel("Between"));
        cpuPanel.add(this.getMinCPUtextField());
        cpuPanel.add(new JLabel("and"));
        cpuPanel.add(this.getMaxCPUtextField());
        cpuPanel.add(this.getCPUpriceLabel());
        cpuPanel.add(new JLabel("Between"));
        cpuPanel.add(this.getMinCPUpriceTextField());
        cpuPanel.add(new JLabel("and"));
        cpuPanel.add(this.getMaxCPUpriceTextField());
        return cpuPanel;
    }

    private JPanel ramPanel() {
        this.setRAMlabel(new JLabel("<html><b>RAM:</b></html>"));
        this.setMinRAMtextField(new JTextField(Integer.toString(50)));
        this.getMinRAMtextField().setPreferredSize(new Dimension(25, 20));
        this.getMinRAMtextField().setHorizontalAlignment(0);
        this.setMaxRAMtextField(new JTextField(Integer.toString(100)));
        this.getMaxRAMtextField().setPreferredSize(new Dimension(25, 20));
        this.getMaxRAMtextField().setHorizontalAlignment(0);
        this.setRAMpriceLabel(new JLabel("<html><b>Unit price:</b></html>"));
        this.setMinRAMpriceTextField(new JTextField(Integer.toString(50)));
        this.getMinRAMpriceTextField().setPreferredSize(new Dimension(25, 20));
        this.getMinRAMpriceTextField().setHorizontalAlignment(0);
        this.setMaxRAMpriceTextField(new JTextField(Integer.toString(100)));
        this.getMaxRAMpriceTextField().setPreferredSize(new Dimension(25, 20));
        this.getMaxRAMpriceTextField().setHorizontalAlignment(0);
        JPanel ramPanel = new JPanel(new FlowLayout(1));
        ramPanel.add(this.getRAMlabel());
        ramPanel.add(new JLabel("Between"));
        ramPanel.add(this.getMinRAMtextField());
        ramPanel.add(new JLabel("and"));
        ramPanel.add(this.getMaxRAMtextField());
        ramPanel.add(this.getRAMpriceLabel());
        ramPanel.add(new JLabel("Between"));
        ramPanel.add(this.getMinRAMpriceTextField());
        ramPanel.add(new JLabel("and"));
        ramPanel.add(this.getMaxRAMpriceTextField());
        return ramPanel;
    }

    private JPanel storagePanel() {
        this.setStorageLabel(new JLabel("<html><b>Storage:</b></html>"));
        this.setMinStorageTextField(new JTextField(Integer.toString(50)));
        this.getMinStorageTextField().setPreferredSize(new Dimension(25, 20));
        this.getMinStorageTextField().setHorizontalAlignment(0);
        this.setMaxStorageTextField(new JTextField(Integer.toString(100)));
        this.getMaxStorageTextField().setPreferredSize(new Dimension(25, 20));
        this.getMaxStorageTextField().setHorizontalAlignment(0);
        this.setStoragePriceLabel(new JLabel("<html><b>Unit price:</b></html>"));
        this.setMinStoragePriceTextField(new JTextField(Integer.toString(50)));
        this.getMinStoragePriceTextField().setPreferredSize(new Dimension(25, 20));
        this.getMinStoragePriceTextField().setHorizontalAlignment(0);
        this.setMaxStoragePriceTextField(new JTextField(Integer.toString(100)));
        this.getMaxStoragePriceTextField().setPreferredSize(new Dimension(25, 20));
        this.getMaxStoragePriceTextField().setHorizontalAlignment(0);
        JPanel storagePanel = new JPanel(new FlowLayout(1));
        storagePanel.add(this.getStorageLabel());
        storagePanel.add(new JLabel("Between"));
        storagePanel.add(this.getMinStorageTextField());
        storagePanel.add(new JLabel("and"));
        storagePanel.add(this.getMaxStorageTextField());
        storagePanel.add(this.getStoragePriceLabel());
        storagePanel.add(new JLabel("Between"));
        storagePanel.add(this.getMinStoragePriceTextField());
        storagePanel.add(new JLabel("and"));
        storagePanel.add(this.getMaxStoragePriceTextField());
        return storagePanel;
    }

    private JPanel maxVirtualNodesNumberPanel() {
        this.setMaxVirtualNodesNumberLabel(new JLabel("<html><b>Maximum virtual nodes number:</b></html>"));
        this.setMaxVirtualNodesNumberTextField(new JTextField(Integer.toString(10)));
        this.getMaxVirtualNodesNumberTextField().setPreferredSize(new Dimension(25, 20));
        this.getMaxVirtualNodesNumberTextField().setHorizontalAlignment(0);
        JPanel maxVirtualNodesNumberPanel = new JPanel(new FlowLayout(1));
        maxVirtualNodesNumberPanel.add(this.getMaxVirtualNodesNumberLabel());
        maxVirtualNodesNumberPanel.add(this.getMaxVirtualNodesNumberTextField());
        return maxVirtualNodesNumberPanel;
    }

    private JPanel linkPanel() {
        TitledBorder titledBorder = BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.black), "<html><b>SDN LINK</b></html>");
        titledBorder.setTitleJustification(2);
        JPanel linkPanel = new JPanel();
        linkPanel.setLayout(new GridLayout(0, 1));
        linkPanel.setBorder(titledBorder);
        linkPanel.add(this.bwPanel());
        linkPanel.add(this.distancePanel());
        return linkPanel;
    }

    private JPanel bwPanel() {
        this.setBWlabel(new JLabel("<html><b>Bandwidth:</b></html>"));
        this.setMinBWtextField(new JTextField(Integer.toString(500)));
        this.getMinBWtextField().setPreferredSize(new Dimension(25, 20));
        this.getMinBWtextField().setHorizontalAlignment(0);
        this.setMaxBWtextField(new JTextField(Integer.toString(1000)));
        this.getMaxBWtextField().setPreferredSize(new Dimension(25, 20));
        this.getMinBWtextField().setHorizontalAlignment(0);
        this.setBWpriceLabel(new JLabel("<html><b>Unit price:</b></html>"));
        this.setMinBWpriceTextField(new JTextField(Integer.toString(50)));
        this.getMinBWpriceTextField().setPreferredSize(new Dimension(25, 20));
        this.getMinBWpriceTextField().setHorizontalAlignment(0);
        this.setMaxBWpriceTextField(new JTextField(Integer.toString(100)));
        this.getMaxBWpriceTextField().setPreferredSize(new Dimension(25, 20));
        this.getMinBWpriceTextField().setHorizontalAlignment(0);
        JPanel bwPanel = new JPanel(new FlowLayout(1));
        bwPanel.add(this.getBWlabel());
        bwPanel.add(new JLabel("Between"));
        bwPanel.add(this.getMinBWtextField());
        bwPanel.add(new JLabel("and"));
        bwPanel.add(this.getMaxBWtextField());
        bwPanel.add(this.getBWpriceLabel());
        bwPanel.add(new JLabel("Between"));
        bwPanel.add(this.getMinBWpriceTextField());
        bwPanel.add(new JLabel("and"));
        bwPanel.add(this.getMaxBWpriceTextField());
        return bwPanel;
    }

    private JPanel distancePanel() {
        this.setDistanceLabel(new JLabel("<html><b>Distance:</b></html>"));
        this.setMinDistanceTextField(new JTextField(Integer.toString(1)));
        this.getMinDistanceTextField().setPreferredSize(new Dimension(25, 20));
        this.getMinDistanceTextField().setHorizontalAlignment(0);
        this.setMaxDistanceTextField(new JTextField(Integer.toString(100)));
        this.getMaxDistanceTextField().setPreferredSize(new Dimension(30, 20));
        this.getMinDistanceTextField().setHorizontalAlignment(0);
        JPanel distancePanel = new JPanel(new FlowLayout(1));
        distancePanel.add(this.getDistanceLabel());
        distancePanel.add(new JLabel("Between"));
        distancePanel.add(this.getMinDistanceTextField());
        distancePanel.add(new JLabel("and"));
        distancePanel.add(this.getMaxDistanceTextField());
        return distancePanel;
    }

    public void addListeners(DocumentListener documentListener, ActionListener actionListener) {
        this.getNetworksNumberTextField().getDocument().addDocumentListener(documentListener);
        this.getMinRoutersNumberTextField().getDocument().addDocumentListener(documentListener);
        this.getMaxRoutersNumberTextField().getDocument().addDocumentListener(documentListener);
        this.getMinSwitchesNumberTextField().getDocument().addDocumentListener(documentListener);
        this.getMaxSwitchesNumberTextField().getDocument().addDocumentListener(documentListener);
        this.getMinServersNumberTextField().getDocument().addDocumentListener(documentListener);
        this.getMaxServersNumberTextField().getDocument().addDocumentListener(documentListener);
        this.getLinuxPercentageTextField().getDocument().addDocumentListener(documentListener);
        this.getWindowsPercentageTextField().getDocument().addDocumentListener(documentListener);
        this.getSolarisPercentageTextField().getDocument().addDocumentListener(documentListener);
        this.getAndroidPercentageTextField().getDocument().addDocumentListener(documentListener);
        this.getMinCPUtextField().getDocument().addDocumentListener(documentListener);
        this.getMaxCPUtextField().getDocument().addDocumentListener(documentListener);
        this.getMinCPUpriceTextField().getDocument().addDocumentListener(documentListener);
        this.getMaxCPUpriceTextField().getDocument().addDocumentListener(documentListener);
        this.getMinRAMtextField().getDocument().addDocumentListener(documentListener);
        this.getMaxRAMtextField().getDocument().addDocumentListener(documentListener);
        this.getMinRAMpriceTextField().getDocument().addDocumentListener(documentListener);
        this.getMaxRAMpriceTextField().getDocument().addDocumentListener(documentListener);
        this.getMinStorageTextField().getDocument().addDocumentListener(documentListener);
        this.getMaxStorageTextField().getDocument().addDocumentListener(documentListener);
        this.getMinStoragePriceTextField().getDocument().addDocumentListener(documentListener);
        this.getMaxStoragePriceTextField().getDocument().addDocumentListener(documentListener);
        this.getMaxVirtualNodesNumberTextField().getDocument().addDocumentListener(documentListener);
        this.getMinBWtextField().getDocument().addDocumentListener(documentListener);
        this.getMaxBWtextField().getDocument().addDocumentListener(documentListener);
        this.getMinBWpriceTextField().getDocument().addDocumentListener(documentListener);
        this.getMaxBWpriceTextField().getDocument().addDocumentListener(documentListener);
        this.getMinDistanceTextField().getDocument().addDocumentListener(documentListener);
        this.getMaxDistanceTextField().getDocument().addDocumentListener(documentListener);
    }

    public boolean check() {
        this.getInformationLabel().setText("Press \"Next\" to create random physical networks");
        this.getInformationLabel().setForeground(Color.BLACK);
        if (!this.checkNetworksNumber()) {
            return false;
        }
        if (!this.checkRoutersNumber()) {
            return false;
        }
        if (!this.checkSwitchesNumber()) {
            return false;
        }
        if (!this.checkServersNumber()) {
            return false;
        }
        if (!this.checkOSpercentages()) {
            return false;
        }
        if (!this.checkCPU()) {
            return false;
        }
        if (!this.checkCPUprice()) {
            return false;
        }
        if (!this.checkRAM()) {
            return false;
        }
        if (!this.checkRAMprice()) {
            return false;
        }
        if (!this.checkStorage()) {
            return false;
        }
        if (!this.checkStoragePrice()) {
            return false;
        }
        if (!this.checkMaxVirtualNodesNumber()) {
            return false;
        }
        if (!this.checkBW()) {
            return false;
        }
        if (!this.checkBWprice()) {
            return false;
        }
        return this.checkDistance();
    }

    private boolean checkNetworksNumber() {
        int lowestNetworksNumber = 1;
        int highestNetworksNumber = 50;
        try {
            int networksNumber = Integer.parseInt(this.getNetworksNumberTextField().getText());
            if (lowestNetworksNumber > networksNumber || networksNumber > highestNetworksNumber) {
                throw new NumberFormatException();
            }
            this.getNetworksNumberLabel().setForeground(Color.BLACK);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            this.getInformationLabel().setText("<html><b>A value between " + lowestNetworksNumber + " and " + highestNetworksNumber + "</b></html>");
            this.getInformationLabel().setForeground(Color.RED);
            this.getNetworksNumberLabel().setForeground(Color.RED);
            return false;
        }
    }

    private boolean checkRoutersNumber() {
        int lowestMinRoutersNumber = 1;
        int highestMaxRoutersNumber = 50;
        try {
            int minRoutersNumber = Integer.parseInt(this.getMinRoutersNumberTextField().getText());
            int maxRoutersNumber = Integer.parseInt(this.getMaxRoutersNumberTextField().getText());
            if (lowestMinRoutersNumber > minRoutersNumber || minRoutersNumber > maxRoutersNumber || maxRoutersNumber > highestMaxRoutersNumber) {
                throw new NumberFormatException();
            }
            this.getRoutersNumberLabel().setForeground(Color.BLACK);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            this.getInformationLabel().setText("<html><b>Minimum value " + lowestMinRoutersNumber + " and maximum value " + highestMaxRoutersNumber + "</b></html>");
            this.getInformationLabel().setForeground(Color.RED);
            this.getRoutersNumberLabel().setForeground(Color.RED);
            return false;
        }
    }

    private boolean checkSwitchesNumber() {
        int lowestMinSwitchesNumber = 1;
        int highestMaxSwitchesNumber = 50;
        try {
            int minSwitchesNumber = Integer.parseInt(this.getMinSwitchesNumberTextField().getText());
            int maxSwitchesNumber = Integer.parseInt(this.getMaxSwitchesNumberTextField().getText());
            if (lowestMinSwitchesNumber > minSwitchesNumber || minSwitchesNumber > maxSwitchesNumber || maxSwitchesNumber > highestMaxSwitchesNumber) {
                throw new NumberFormatException();
            }
            this.getSwitchesNumberLabel().setForeground(Color.BLACK);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            this.getInformationLabel().setText("<html><b>Minimum value " + lowestMinSwitchesNumber + " and maximum value " + highestMaxSwitchesNumber + "</b></html>");
            this.getInformationLabel().setForeground(Color.RED);
            this.getSwitchesNumberLabel().setForeground(Color.RED);
            return false;
        }
    }

    private boolean checkServersNumber() {
        int lowestMinServersNumber = 1;
        int highestMaxServersNumber = 50;
        try {
            int minServersNumber = Integer.parseInt(this.getMinServersNumberTextField().getText());
            int maxServersNumber = Integer.parseInt(this.getMaxServersNumberTextField().getText());
            if (lowestMinServersNumber > minServersNumber || minServersNumber > maxServersNumber || maxServersNumber > highestMaxServersNumber) {
                throw new NumberFormatException();
            }
            this.getServersNumberLabel().setForeground(Color.BLACK);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            this.getInformationLabel().setText("<html><b>Minimum value " + lowestMinServersNumber + " and maximum value " + highestMaxServersNumber + "</b></html>");
            this.getInformationLabel().setForeground(Color.RED);
            this.getServersNumberLabel().setForeground(Color.RED);
            return false;
        }
    }

    private boolean checkOSpercentages() {
        try {
            int linuxPercentage = Integer.parseInt(this.getLinuxPercentageTextField().getText());
            int windowsPercentage = Integer.parseInt(this.getWindowsPercentageTextField().getText());
            int solarisPercentage = Integer.parseInt(this.getSolarisPercentageTextField().getText());
            int androidPercentage = Integer.parseInt(this.getAndroidPercentageTextField().getText());
            if (linuxPercentage < 0 || linuxPercentage > 100 || windowsPercentage < 0 || windowsPercentage > 100 || solarisPercentage < 0 || solarisPercentage > 100 || androidPercentage < 0 || androidPercentage > 100 || linuxPercentage + windowsPercentage + solarisPercentage + androidPercentage != 100) {
                throw new NumberFormatException();
            }
            this.getOSlabel().setForeground(Color.BLACK);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            this.getInformationLabel().setText("<html><b>Operating systems of nodes must sum to 100</b></html>");
            this.getInformationLabel().setForeground(Color.RED);
            this.getOSlabel().setForeground(Color.RED);
            return false;
        }
    }

    private boolean checkCPU() {
        int lowestMinCPU = 0;
        int highestMaxCPU = 100;
        try {
            int minCPU = Integer.parseInt(this.getMinCPUtextField().getText());
            int maxCPU = Integer.parseInt(this.getMaxCPUtextField().getText());
            if (lowestMinCPU > minCPU || minCPU > maxCPU || maxCPU > highestMaxCPU) {
                throw new NumberFormatException();
            }
            this.getCPUlabel().setForeground(Color.BLACK);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            this.getInformationLabel().setText("<html><b>Minimum value " + lowestMinCPU + " and maximum value " + highestMaxCPU + "</b></html>");
            this.getInformationLabel().setForeground(Color.RED);
            this.getCPUlabel().setForeground(Color.RED);
            return false;
        }
    }

    private boolean checkCPUprice() {
        int lowestMinCPUprice = 0;
        int highestMaxCPUprice = 100;
        try {
            int minCPUprice = Integer.parseInt(this.getMinCPUpriceTextField().getText());
            int maxCPUprice = Integer.parseInt(this.getMaxCPUpriceTextField().getText());
            if (lowestMinCPUprice > minCPUprice || minCPUprice > maxCPUprice || maxCPUprice > highestMaxCPUprice) {
                throw new NumberFormatException();
            }
            this.getCPUpriceLabel().setForeground(Color.BLACK);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            this.getInformationLabel().setText("<html><b>Minimum value " + lowestMinCPUprice + " and maximum value " + highestMaxCPUprice + "</b></html>");
            this.getInformationLabel().setForeground(Color.RED);
            this.getCPUpriceLabel().setForeground(Color.RED);
            return false;
        }
    }

    private boolean checkRAM() {
        int lowestMinRAM = 0;
        int highestMaxRAM = 100;
        try {
            int minRAM = Integer.parseInt(this.getMinRAMtextField().getText());
            int maxRAM = Integer.parseInt(this.getMaxRAMtextField().getText());
            if (lowestMinRAM > minRAM || minRAM > maxRAM || maxRAM > 100) {
                throw new NumberFormatException();
            }
            this.getRAMlabel().setForeground(Color.BLACK);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            this.getInformationLabel().setText("<html><b>Minimum value " + lowestMinRAM + " and maximum value " + highestMaxRAM + "</b></html>");
            this.getInformationLabel().setForeground(Color.RED);
            this.getRAMlabel().setForeground(Color.RED);
            return false;
        }
    }

    private boolean checkRAMprice() {
        int lowestMinRAMprice = 0;
        int highestMaxRAMprice = 100;
        try {
            int minRAMprice = Integer.parseInt(this.getMinRAMpriceTextField().getText());
            int maxRAMprice = Integer.parseInt(this.getMaxRAMpriceTextField().getText());
            if (lowestMinRAMprice > minRAMprice || minRAMprice > maxRAMprice || maxRAMprice > highestMaxRAMprice) {
                throw new NumberFormatException();
            }
            this.getRAMpriceLabel().setForeground(Color.BLACK);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            this.getInformationLabel().setText("<html><b>Minimum value " + lowestMinRAMprice + " and maximum value " + highestMaxRAMprice + "</b></html>");
            this.getInformationLabel().setForeground(Color.RED);
            this.getRAMpriceLabel().setForeground(Color.RED);
            return false;
        }
    }

    private boolean checkStorage() {
        int lowestMinStorage = 0;
        int highestMaxStorage = 100;
        try {
            int minStorage = Integer.parseInt(this.getMinStorageTextField().getText());
            int maxStorage = Integer.parseInt(this.getMaxStorageTextField().getText());
            if (lowestMinStorage > minStorage || minStorage > maxStorage || maxStorage > highestMaxStorage) {
                throw new NumberFormatException();
            }
            this.getStorageLabel().setForeground(Color.BLACK);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            this.getInformationLabel().setText("<html><b>Minimum value " + lowestMinStorage + " and maximum value " + highestMaxStorage + "</b></html>");
            this.getInformationLabel().setForeground(Color.RED);
            this.getStorageLabel().setForeground(Color.RED);
            return false;
        }
    }

    private boolean checkStoragePrice() {
        int lowestMinStoragePrice = 0;
        int highestMaxStoragePrice = 100;
        try {
            int minDiskStoragePrice = Integer.parseInt(this.getMinStoragePriceTextField().getText());
            int maxDiskStoragePrice = Integer.parseInt(this.getMaxStoragePriceTextField().getText());
            if (lowestMinStoragePrice > minDiskStoragePrice || minDiskStoragePrice > maxDiskStoragePrice || maxDiskStoragePrice > highestMaxStoragePrice) {
                throw new NumberFormatException();
            }
            this.getStoragePriceLabel().setForeground(Color.BLACK);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            this.getInformationLabel().setText("<html><b>Minimum value " + lowestMinStoragePrice + " and maximum value " + highestMaxStoragePrice + "</b></html>");
            this.getInformationLabel().setForeground(Color.RED);
            this.getStoragePriceLabel().setForeground(Color.RED);
            return false;
        }
    }

    private boolean checkMaxVirtualNodesNumber() {
        int lowestMaxVirtualNodesNumber = 1;
        int highestMaxVirtualNodesNumber = 50;
        try {
            int maxVirtualNodesNumber = Integer.parseInt(this.getMaxVirtualNodesNumberTextField().getText());
            if (lowestMaxVirtualNodesNumber > maxVirtualNodesNumber || maxVirtualNodesNumber > highestMaxVirtualNodesNumber) {
                throw new NumberFormatException();
            }
            this.getMaxVirtualNodesNumberLabel().setForeground(Color.BLACK);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            this.getInformationLabel().setText("<html><b>A value between " + lowestMaxVirtualNodesNumber + " and " + highestMaxVirtualNodesNumber + "</b></html>");
            this.getInformationLabel().setForeground(Color.RED);
            this.getMaxVirtualNodesNumberLabel().setForeground(Color.RED);
            return false;
        }
    }

    private boolean checkBW() {
        int lowestMinBW = 0;
        int highestMaxBW = 100;
        try {
            int minBW = Integer.parseInt(this.getMinBWtextField().getText());
            int maxBW = Integer.parseInt(this.getMaxBWtextField().getText());
            if (lowestMinBW > minBW || minBW > maxBW || maxBW > highestMaxBW) {
                throw new NumberFormatException();
            }
            this.getBWlabel().setForeground(Color.BLACK);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            this.getInformationLabel().setText("<html><b>Minimum value " + lowestMinBW + " and maximum value " + highestMaxBW + "</b></html>");
            this.getInformationLabel().setForeground(Color.RED);
            this.getBWlabel().setForeground(Color.RED);
            return false;
        }
    }

    private boolean checkBWprice() {
        int lowestMinBWprice = 0;
        int highestMaxBWprice = 100;
        try {
            int minBWprice = Integer.parseInt(this.getMinBWpriceTextField().getText());
            int maxBWprice = Integer.parseInt(this.getMaxBWpriceTextField().getText());
            if (lowestMinBWprice > minBWprice || minBWprice > maxBWprice || maxBWprice > highestMaxBWprice) {
                throw new NumberFormatException();
            }
            this.getBWpriceLabel().setForeground(Color.BLACK);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            this.getInformationLabel().setText("<html><b>Minimum value " + lowestMinBWprice + " and maximum value " + highestMaxBWprice + "</b></html>");
            this.getInformationLabel().setForeground(Color.RED);
            this.getBWpriceLabel().setForeground(Color.RED);
            return false;
        }
    }

    private boolean checkDistance() {
        int lowestMinDistance = 1;
        int highetsMaxDistance = 100;
        try {
            int minDistance = Integer.parseInt(this.getMinDistanceTextField().getText());
            int maxDistance = Integer.parseInt(this.getMaxDistanceTextField().getText());
            if (lowestMinDistance > minDistance || minDistance > maxDistance || maxDistance > highetsMaxDistance) {
                throw new NumberFormatException();
            }
            this.getDistanceLabel().setForeground(Color.BLACK);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            this.getInformationLabel().setText("<html><b>Minimum value " + lowestMinDistance + " and maximum value " + highetsMaxDistance + "</b></html>");
            this.getInformationLabel().setForeground(Color.RED);
            this.getDistanceLabel().setForeground(Color.RED);
            return false;
        }
    }
}

