/*
 * Decompiled with CFR 0.152.
 */
package frame.options.sdn;

import frame.SimulatorFrame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.List;
import java.util.Locale;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import jxl.Workbook;
import jxl.WorkbookSettings;
import jxl.format.CellFormat;
import jxl.write.Label;
import jxl.write.Number;
import jxl.write.WritableCellFormat;
import jxl.write.WritableFont;
import jxl.write.WritableSheet;
import jxl.write.WritableWorkbook;
import model.components.links.link.SdnLink;
import model.components.networks.sdn.SdnNetwork;
import model.components.nodes.node.sdn.SdnNode;

public class SaveSdnMenuItem
extends JMenuItem
implements ActionListener {
    private SimulatorFrame simulatorFrame;
    private JFileChooser fileChooser;

    public SimulatorFrame getFrame() {
        return this.simulatorFrame;
    }

    public void setFrame(SimulatorFrame simulatorFrame) {
        this.simulatorFrame = simulatorFrame;
    }

    public JFileChooser getFileChooser() {
        return this.fileChooser;
    }

    public void setFileChooser(JFileChooser fileChooser) {
        this.fileChooser = fileChooser;
    }

    public SaveSdnMenuItem(SimulatorFrame simulatorFrame) {
        this.setFrame(simulatorFrame);
        this.setText("Save");
        this.setMnemonic(83);
        this.setIcon(new ImageIcon(this.getClass().getResource("/icons/save.png")));
        this.setFileChooser(new JFileChooser());
        this.addActionListener(this);
        if (this.getFrame().getSimulator().getSdnNetworks().size() == 0) {
            this.setEnabled(false);
        } else {
            this.setEnabled(true);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.getFrame().getNetworksPanel().getNetworksTablesTabbedPane().setSelectedIndex(0);
        this.getFileChooser().setSelectedFile(new File(String.valueOf(this.getFrame().getSimulator().getSdnNetworks().get(0).getNamePrefix()) + "s"));
        if (this.getFileChooser().showSaveDialog(this) == 0) {
            try {
                if (this.existFile(new File(String.valueOf(this.getFileChooser().getSelectedFile().toString()) + ".xls"))) {
                    throw new Exception();
                }
                this.saveSdnNetworks(this.getFrame().getSimulator().getSdnNetworks(), this.getFileChooser().getSelectedFile().toString());
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(this.getFrame().getNetworksPanel(), "Already exists file", "File name error", 1);
            }
        }
    }

    private boolean existFile(File file) {
        try {
            Workbook workbook = Workbook.getWorkbook(file);
            workbook.close();
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private void saveSdnNetworks(List<SdnNetwork> sdnNetworks, String file) throws Exception {
        WorkbookSettings workbookSettings = new WorkbookSettings();
        workbookSettings.setLocale(new Locale("en", "EN"));
        WritableWorkbook writableWorkbook = Workbook.createWorkbook(new File(String.valueOf(file) + ".xls"), workbookSettings);
        WritableFont writableFontBold = new WritableFont(WritableFont.ARIAL, 10, WritableFont.BOLD);
        WritableCellFormat writableCellFormatBold = new WritableCellFormat(writableFontBold);
        writableCellFormatBold.setWrap(true);
        WritableFont writableFontNoBold = new WritableFont(WritableFont.ARIAL, 10, WritableFont.NO_BOLD);
        WritableCellFormat writableCellFormatNoBold = new WritableCellFormat(writableFontNoBold);
        writableCellFormatNoBold.setWrap(true);
        int indexSheet = 0;
        for (SdnNetwork sdnNetwork : sdnNetworks) {
            WritableSheet writableSheet = writableWorkbook.createSheet(sdnNetwork.getName(), indexSheet++);
            int rowCount = 0;
            int columnCount = 0;
            writableSheet.addCell(new Label(columnCount++, rowCount, "NETWORK", (CellFormat)writableCellFormatBold));
            columnCount = 0;
            writableSheet.addCell(new Label(columnCount++, ++rowCount, "Name prefix", (CellFormat)writableCellFormatBold));
            writableSheet.addCell(new Label(columnCount++, rowCount, "Number", (CellFormat)writableCellFormatBold));
            writableSheet.addCell(new Label(columnCount++, rowCount, "CPU price", (CellFormat)writableCellFormatBold));
            writableSheet.addCell(new Label(columnCount++, rowCount, "RAM price", (CellFormat)writableCellFormatBold));
            writableSheet.addCell(new Label(columnCount++, rowCount, "Storage price", (CellFormat)writableCellFormatBold));
            writableSheet.addCell(new Label(columnCount++, rowCount, "BW price", (CellFormat)writableCellFormatBold));
            columnCount = 0;
            writableSheet.addCell(new Label(columnCount++, ++rowCount, sdnNetwork.getNamePrefix(), (CellFormat)writableCellFormatNoBold));
            writableSheet.addCell(new Number(columnCount++, rowCount, (double)sdnNetwork.getNumber(), (CellFormat)writableCellFormatNoBold));
            writableSheet.addCell(new Number(columnCount++, rowCount, (double)sdnNetwork.getCPUprice(), (CellFormat)writableCellFormatNoBold));
            writableSheet.addCell(new Number(columnCount++, rowCount, (double)sdnNetwork.getRAMprice(), (CellFormat)writableCellFormatNoBold));
            writableSheet.addCell(new Number(columnCount++, rowCount, (double)sdnNetwork.getStoragePrice(), (CellFormat)writableCellFormatNoBold));
            writableSheet.addCell(new Number(columnCount++, rowCount, (double)sdnNetwork.getBWprice(), (CellFormat)writableCellFormatNoBold));
            columnCount = 0;
            writableSheet.addCell(new Label(columnCount++, ++rowCount, "NODES", (CellFormat)writableCellFormatBold));
            columnCount = 0;
            writableSheet.addCell(new Label(columnCount++, ++rowCount, "Network name", (CellFormat)writableCellFormatBold));
            writableSheet.addCell(new Label(columnCount++, rowCount, "Number", (CellFormat)writableCellFormatBold));
            writableSheet.addCell(new Label(columnCount++, rowCount, "Type", (CellFormat)writableCellFormatBold));
            writableSheet.addCell(new Label(columnCount++, rowCount, "OS", (CellFormat)writableCellFormatBold));
            writableSheet.addCell(new Label(columnCount++, rowCount, "CPU", (CellFormat)writableCellFormatBold));
            writableSheet.addCell(new Label(columnCount++, rowCount, "RAM", (CellFormat)writableCellFormatBold));
            writableSheet.addCell(new Label(columnCount++, rowCount, "Storage", (CellFormat)writableCellFormatBold));
            writableSheet.addCell(new Label(columnCount++, rowCount, "Virtual nodes number", (CellFormat)writableCellFormatBold));
            ++rowCount;
            for (SdnNode sdnNode : sdnNetwork.getSdnNodes()) {
                columnCount = 0;
                writableSheet.addCell(new Label(columnCount++, rowCount, sdnNode.getNetworkName(), (CellFormat)writableCellFormatNoBold));
                writableSheet.addCell(new Number(columnCount++, rowCount, (double)sdnNode.getNumber(), (CellFormat)writableCellFormatNoBold));
                writableSheet.addCell(new Label(columnCount++, rowCount, sdnNode.getType(), (CellFormat)writableCellFormatNoBold));
                writableSheet.addCell(new Label(columnCount++, rowCount, sdnNode.getOS(), (CellFormat)writableCellFormatNoBold));
                writableSheet.addCell(new Number(columnCount++, rowCount, (double)sdnNode.getCPU(), (CellFormat)writableCellFormatNoBold));
                writableSheet.addCell(new Number(columnCount++, rowCount, (double)sdnNode.getRAM(), (CellFormat)writableCellFormatNoBold));
                writableSheet.addCell(new Number(columnCount++, rowCount, (double)sdnNode.getStorage(), (CellFormat)writableCellFormatNoBold));
                writableSheet.addCell(new Number(columnCount++, rowCount, (double)sdnNode.getMaxVirtualNodesNumber(), (CellFormat)writableCellFormatNoBold));
                ++rowCount;
            }
            columnCount = 0;
            writableSheet.addCell(new Label(columnCount++, rowCount, "LINKS", (CellFormat)writableCellFormatBold));
            columnCount = 0;
            writableSheet.addCell(new Label(columnCount++, ++rowCount, "Network name", (CellFormat)writableCellFormatBold));
            writableSheet.addCell(new Label(columnCount++, rowCount, "Number", (CellFormat)writableCellFormatBold));
            writableSheet.addCell(new Label(columnCount++, rowCount, "First node", (CellFormat)writableCellFormatBold));
            writableSheet.addCell(new Label(columnCount++, rowCount, "Second node", (CellFormat)writableCellFormatBold));
            writableSheet.addCell(new Label(columnCount++, rowCount, "BW", (CellFormat)writableCellFormatBold));
            writableSheet.addCell(new Label(columnCount++, rowCount, "Distance", (CellFormat)writableCellFormatBold));
            ++rowCount;
            for (SdnLink physicalLink : sdnNetwork.getSdnLinks()) {
                columnCount = 0;
                writableSheet.addCell(new Label(columnCount++, rowCount, physicalLink.getNetworkName(), (CellFormat)writableCellFormatNoBold));
                writableSheet.addCell(new Number(columnCount++, rowCount, (double)physicalLink.getNumber(), (CellFormat)writableCellFormatNoBold));
                writableSheet.addCell(new Label(columnCount++, rowCount, physicalLink.getFirstNode().getName(), (CellFormat)writableCellFormatNoBold));
                writableSheet.addCell(new Label(columnCount++, rowCount, physicalLink.getSecondNode().getName(), (CellFormat)writableCellFormatNoBold));
                writableSheet.addCell(new Number(columnCount++, rowCount, (double)physicalLink.getBW(), (CellFormat)writableCellFormatNoBold));
                writableSheet.addCell(new Number(columnCount++, rowCount, (double)physicalLink.getDistance(), (CellFormat)writableCellFormatNoBold));
                ++rowCount;
            }
            columnCount = 0;
            writableSheet.addCell(new Label(columnCount++, rowCount, "END", (CellFormat)writableCellFormatBold));
            ++rowCount;
        }
        writableWorkbook.write();
        writableWorkbook.close();
    }
}

