/*
 * Decompiled with CFR 0.152.
 */
package frame.options.sdn;

import frame.SimulatorFrame;
import frame.networks.tables.sdn.SdnTableModel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import jxl.LabelCell;
import jxl.NumberCell;
import jxl.Sheet;
import jxl.Workbook;
import jxl.write.WritableCellFormat;
import jxl.write.WritableFont;
import model.components.links.link.SdnLink;
import model.components.networks.NetworkGraph;
import model.components.networks.sdn.SdnNetwork;
import model.components.nodes.node.Node;
import model.components.nodes.node.sdn.SdnNode;
import model.components.nodes.node.sdn.SdnRouter;
import model.components.nodes.node.sdn.SdnServer;
import model.components.nodes.node.sdn.SdnSwitch;

public class OpenSdnMenuItem
extends JMenuItem
implements ActionListener {
    private SimulatorFrame simulatorFrame;
    private JFileChooser fileChooser;

    public SimulatorFrame getFrame() {
        return this.simulatorFrame;
    }

    public void setFrame(SimulatorFrame simulatorFrame) {
        this.simulatorFrame = simulatorFrame;
    }

    public JFileChooser getFileChooser() {
        return this.fileChooser;
    }

    public void setFileChooser(JFileChooser fileChooser) {
        this.fileChooser = fileChooser;
    }

    public OpenSdnMenuItem(SimulatorFrame simulatorFrame) {
        this.setFrame(simulatorFrame);
        this.setText("Open");
        this.setMnemonic(79);
        this.setIcon(new ImageIcon(this.getClass().getResource("/icons/open.png")));
        this.setFileChooser(new JFileChooser());
        this.addActionListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.getFrame().getNetworksPanel().getNetworksTablesTabbedPane().setSelectedIndex(0);
        if (this.getFileChooser().showOpenDialog(this) == 0) {
            try {
                List<SdnNetwork> sdnNetworks = this.openSdnNetworks(this.getFileChooser().getSelectedFile());
                this.getFrame().getNetworksPanel().getSdnNetworksViewersTabbedPane().removeAll();
                this.getFrame().getNetworksPanel().getNetworksTablesTabbedPane().getSdnNetworksTable().removeAll();
                this.getFrame().getSimulator().setInitSdnNetworks(sdnNetworks);
                this.getFrame().getSimulator().reset();
                for (SdnNetwork sdnNetwork : sdnNetworks) {
                    this.getFrame().getNetworksPanel().getSdnNetworksViewersTabbedPane().addSdnNetworkTab(sdnNetwork);
                    ((SdnTableModel)this.getFrame().getNetworksPanel().getNetworksTablesTabbedPane().getSdnNetworksTable().getModel()).addRow(new Object[]{sdnNetwork.getName(), sdnNetwork.getState()});
                }
                ((SdnTableModel)this.getFrame().getNetworksPanel().getNetworksTablesTabbedPane().getSdnNetworksTable().getModel()).refresh();
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(this.getFrame().getNetworksPanel(), "Incorrect file", "Filer error", 1);
            }
        }
    }

    private List<SdnNetwork> openSdnNetworks(File file) throws Exception {
        ArrayList<SdnNetwork> sdnNetworks = new ArrayList<SdnNetwork>();
        Workbook workbook = Workbook.getWorkbook(file);
        WritableFont writableFontBold = new WritableFont(WritableFont.ARIAL, 10, WritableFont.BOLD);
        WritableCellFormat writableCellFormatBold = new WritableCellFormat(writableFontBold);
        writableCellFormatBold.setWrap(true);
        WritableFont writableFontNoBold = new WritableFont(WritableFont.ARIAL, 10, WritableFont.NO_BOLD);
        WritableCellFormat writableCellFormatNoBold = new WritableCellFormat(writableFontNoBold);
        writableCellFormatNoBold.setWrap(true);
        String[] sheetNames = workbook.getSheetNames();
        int sheetCount = 0;
        while (sheetCount < sheetNames.length) {
            int number;
            Sheet sheet = workbook.getSheet(sheetNames[sheetCount++]);
            int columnCount = 0;
            int rowCount = 2;
            String namePrefix = sheet.getCell(columnCount++, rowCount).getContents();
            int networkNumber = Integer.parseInt(sheet.getCell(columnCount++, rowCount).getContents());
            int cpuPrice = Integer.parseInt(sheet.getCell(columnCount++, rowCount).getContents());
            int ramPrice = Integer.parseInt(sheet.getCell(columnCount++, rowCount).getContents());
            int storagePrice = Integer.parseInt(sheet.getCell(columnCount++, rowCount).getContents());
            int bwPrice = Integer.parseInt(sheet.getCell(columnCount++, rowCount).getContents());
            SdnNetwork sdnNetwork = new SdnNetwork(namePrefix, networkNumber, new NetworkGraph(), cpuPrice, ramPrice, storagePrice, bwPrice);
            ArrayList<Node> nodes = new ArrayList<Node>();
            columnCount = 0;
            rowCount = 5;
            while (!sheet.getCell(columnCount, rowCount).getContents().equals("LINKS")) {
                String nameNetwork = ((LabelCell)sheet.getCell(columnCount++, rowCount)).getString();
                number = (int)((NumberCell)sheet.getCell(columnCount++, rowCount)).getValue();
                String type = ((LabelCell)sheet.getCell(columnCount++, rowCount)).getString();
                String os = ((LabelCell)sheet.getCell(columnCount++, rowCount)).getString();
                int cpu = (int)((NumberCell)sheet.getCell(columnCount++, rowCount)).getValue();
                int ram = (int)((NumberCell)sheet.getCell(columnCount++, rowCount)).getValue();
                int storage = (int)((NumberCell)sheet.getCell(columnCount++, rowCount)).getValue();
                int maxVirtualNodesNumber = (int)((NumberCell)sheet.getCell(columnCount++, rowCount)).getValue();
                columnCount = 0;
                ++rowCount;
                SdnNode sdnNode = null;
                if (type.equals("Router")) {
                    sdnNode = new SdnRouter(nameNetwork, number, os, cpu, ram, maxVirtualNodesNumber);
                } else if (type.equals("Switch")) {
                    sdnNode = new SdnSwitch(nameNetwork, number, os, cpu, ram, maxVirtualNodesNumber);
                } else if (type.equals("Server")) {
                    sdnNode = new SdnServer(nameNetwork, number, os, cpu, ram, storage, maxVirtualNodesNumber);
                }
                sdnNode.setInitialNumber(number);
                nodes.add(sdnNode);
            }
            columnCount = 0;
            rowCount += 2;
            while (!sheet.getCell(columnCount, rowCount).getContents().equals("END")) {
                String networkName = sheet.getCell(columnCount++, rowCount).getContents();
                number = Integer.parseInt(sheet.getCell(columnCount++, rowCount).getContents());
                String firstNodeName = sheet.getCell(columnCount++, rowCount).getContents();
                String secondNodeName = sheet.getCell(columnCount++, rowCount).getContents();
                int bandwidth = Integer.parseInt(sheet.getCell(columnCount++, rowCount).getContents());
                int distance = Integer.parseInt(sheet.getCell(columnCount++, rowCount).getContents());
                columnCount = 0;
                ++rowCount;
                SdnLink sdnLink = new SdnLink(networkName, number, bandwidth, distance);
                Node firstNode = this.getNodeByName(firstNodeName, nodes);
                Node secondNode = this.getNodeByName(secondNodeName, nodes);
                sdnLink.setInitialNumber(number);
                sdnLink.setDistance(distance);
                sdnNetwork.addLinkAndNodes(sdnLink, firstNode, secondNode);
            }
            sdnNetworks.add(sdnNetwork);
        }
        workbook.close();
        return sdnNetworks;
    }

    private Node getNodeByName(String nodeName, List<Node> nodes) {
        for (Node node : nodes) {
            if (!node.getName().equals(nodeName)) continue;
            return node;
        }
        return null;
    }
}

