/*
 * Decompiled with CFR 0.152.
 */
package frame.networks.viewers.viewer;

import edu.uci.ics.jung.algorithms.layout.Layout;
import edu.uci.ics.jung.visualization.VisualizationViewer;
import edu.uci.ics.jung.visualization.control.DefaultModalGraphMouse;
import edu.uci.ics.jung.visualization.control.ModalGraphMouse;
import edu.uci.ics.jung.visualization.decorators.EdgeShape;
import edu.uci.ics.jung.visualization.renderers.Renderer;
import frame.SimulatorFrame;
import frame.networks.viewers.viewer.LinkColorTransformer;
import frame.networks.viewers.viewer.NetworkPopupGraphMousePlugin;
import frame.networks.viewers.viewer.NodeIconTransformer;
import frame.networks.viewers.viewer.NodeLabelTransformer;
import model.components.links.link.Link;
import model.components.nodes.node.Node;

public class NetworkVisualizationViewer
extends VisualizationViewer<Node, Link> {
    private NetworkPopupGraphMousePlugin networkPopupGraphMousePlugin;

    public NetworkPopupGraphMousePlugin getNetworkPopupGraphMousePlugin() {
        return this.networkPopupGraphMousePlugin;
    }

    public void setNetworkPopupGraphMousePlugin(NetworkPopupGraphMousePlugin networkPopupGraphMousePlugin) {
        this.networkPopupGraphMousePlugin = networkPopupGraphMousePlugin;
    }

    public NetworkVisualizationViewer(Layout<Node, Link> layout, SimulatorFrame simulatorFrame) {
        super(layout);
        this.setNetworkPopupGraphMousePlugin(new NetworkPopupGraphMousePlugin(simulatorFrame));
        this.getRenderContext().setVertexIconTransformer(new NodeIconTransformer());
        this.getRenderContext().setVertexLabelTransformer(new NodeLabelTransformer());
        this.getRenderContext().setEdgeShapeTransformer(new EdgeShape.CubicCurve());
        this.getRenderContext().setEdgeDrawPaintTransformer(new LinkColorTransformer());
        this.getRenderer().getVertexLabelRenderer().setPosition(Renderer.VertexLabel.Position.AUTO);
        DefaultModalGraphMouse defaultModalGraphMouse = new DefaultModalGraphMouse();
        defaultModalGraphMouse.setMode(ModalGraphMouse.Mode.TRANSFORMING);
        defaultModalGraphMouse.add(this.getNetworkPopupGraphMousePlugin());
        this.addKeyListener(defaultModalGraphMouse.getModeKeyListener());
        this.setGraphMouse(defaultModalGraphMouse);
    }
}

