/*
 * Decompiled with CFR 0.152.
 */
package frame.networks.viewers.viewer;

import edu.uci.ics.jung.visualization.VisualizationViewer;
import edu.uci.ics.jung.visualization.control.AbstractPopupGraphMousePlugin;
import frame.SimulatorFrame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import model.components.links.link.Link;
import model.components.links.link.SdnLink;
import model.components.links.link.VirtualLink;
import model.components.networks.sdn.SdnNetwork;
import model.components.networks.virtual.VirtualNetwork;
import model.components.nodes.node.Node;
import model.components.nodes.node.sdn.SdnNode;
import model.components.nodes.node.sdn.SdnRouter;
import model.components.nodes.node.sdn.SdnServer;
import model.components.nodes.node.sdn.SdnSwitch;
import model.components.nodes.node.virtual.VirtualMachine;
import model.components.nodes.node.virtual.VirtualNode;
import model.components.nodes.node.virtual.VirtualRouter;
import model.components.nodes.node.virtual.VirtualSwitch;

public class NetworkPopupGraphMousePlugin
extends AbstractPopupGraphMousePlugin
implements ActionListener {
    private Node node;
    private JPopupMenu nodePopupMenu;
    private Link link;
    private JPopupMenu linkPopupMenu;
    private SimulatorFrame simulatorFrame;

    public Node getNode() {
        return this.node;
    }

    public void setNode(Node node) {
        this.node = node;
    }

    public JPopupMenu getNodePopupMenu() {
        return this.nodePopupMenu;
    }

    public void setNodePopupMenu(JPopupMenu nodePopupMenu) {
        this.nodePopupMenu = nodePopupMenu;
    }

    public Link getLink() {
        return this.link;
    }

    public void setLink(Link link) {
        this.link = link;
    }

    public JPopupMenu getLinkPopupMenu() {
        return this.linkPopupMenu;
    }

    public void setLinkPopupMenu(JPopupMenu linkPopupMenu) {
        this.linkPopupMenu = linkPopupMenu;
    }

    public SimulatorFrame getFrame() {
        return this.simulatorFrame;
    }

    public void setFrame(SimulatorFrame simulatorFrame) {
        this.simulatorFrame = simulatorFrame;
    }

    public NetworkPopupGraphMousePlugin(SimulatorFrame simulatorFrame) {
        super(4);
        this.setFrame(simulatorFrame);
        this.setNodePopupMenu(new JPopupMenu());
        this.setLinkPopupMenu(new JPopupMenu());
    }

    @Override
    protected void handlePopup(MouseEvent mouseEvent) {
        VisualizationViewer visualizationViewer = (VisualizationViewer)mouseEvent.getSource();
        Node node = (Node)visualizationViewer.getPickSupport().getVertex(visualizationViewer.getGraphLayout(), mouseEvent.getPoint().getX(), mouseEvent.getPoint().getY());
        this.setNode(node);
        Link link = (Link)visualizationViewer.getPickSupport().getEdge(visualizationViewer.getGraphLayout(), mouseEvent.getPoint().getX(), mouseEvent.getPoint().getY());
        this.setLink(link);
        if (node != null) {
            this.updateNodePopupMenu(node);
            this.getNodePopupMenu().show(visualizationViewer, mouseEvent.getX(), mouseEvent.getY());
        } else if (link != null) {
            this.updateLinkPopupMenu(link);
            this.getLinkPopupMenu().show(visualizationViewer, mouseEvent.getX(), mouseEvent.getY());
        }
    }

    private void updateNodePopupMenu(Node node) {
        this.getNodePopupMenu().removeAll();
        this.getNodePopupMenu().add(this.nodeMenuItem(node));
    }

    private JMenuItem nodeMenuItem(Node node) {
        Icon icon = null;
        icon = node.isSelected() ? node.getGreenIcon() : node.getGreyIcon();
        String text = null;
        if (node instanceof SdnRouter || node instanceof VirtualRouter || node instanceof SdnSwitch || node instanceof VirtualSwitch) {
            text = "<html><b>" + node.getNetworkName() + ": </b>" + node.getName() + "<br><b>OS: </b>" + node.getOS() + "<br><b>CPU: </b>" + node.getCPU() + " <b>RAM: </b>" + node.getRAM() + "</html>";
        } else if (node instanceof SdnServer || node instanceof VirtualMachine) {
            text = "<html><b>" + node.getNetworkName() + ": </b>" + node.getName() + "<br><b>OS: </b>" + node.getOS() + "<br><b>CPU: </b>" + node.getCPU() + " <b>RAM: </b>" + node.getRAM() + " <b>STORAGE: </b>" + node.getStorage() + "</html>";
        }
        JMenuItem nodeMenuItem = new JMenuItem();
        nodeMenuItem.setIcon(icon);
        nodeMenuItem.setText(text);
        nodeMenuItem.addActionListener(this);
        return nodeMenuItem;
    }

    private void updateLinkPopupMenu(Link link) {
        this.getLinkPopupMenu().removeAll();
        this.getLinkPopupMenu().add(this.linkMenuItem(link));
    }

    private JMenuItem linkMenuItem(Link link) {
        String iconURL = null;
        String text = "";
        Node firstNode = link.getFirstNode();
        Node secondNode = link.getSecondNode();
        if (link instanceof SdnLink) {
            iconURL = "/icons/physicalLink.png";
            text = "<html><b>" + link.getNetworkName() + ": </b>" + link.getName() + " <b>BW: </b> " + link.getBW() + "<br><b>Endpoints: </b>" + firstNode.getName() + "-" + secondNode.getName() + "<br><b>Distance: </b>" + ((SdnLink)link).getDistance() + "</html>";
        } else if (link instanceof VirtualLink) {
            iconURL = "/icons/virtualLink.png";
            text = "<html><b>" + link.getNetworkName() + ": </b>" + link.getName() + " <b>BW: </b> " + link.getBW() + "<br><b>Endpoints: </b>" + firstNode.getName() + "-" + secondNode.getName() + "</html>";
        }
        JMenuItem linkMenuItem = new JMenuItem();
        linkMenuItem.setText(text);
        linkMenuItem.setIcon(new ImageIcon(this.getClass().getResource(iconURL)));
        linkMenuItem.addActionListener(this);
        return linkMenuItem;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.setFalseSelectedSdnNetworks();
        this.setFalseSelectedVirtualNetworks();
        if (this.getNode() != null) {
            this.getNode().setSelected(true);
        } else if (this.getLink() != null) {
            this.getLink().setSelected(true);
            this.getLink().getFirstNode().setSelected(true);
            this.getLink().getSecondNode().setSelected(true);
        }
        this.getFrame().getNetworksPanel().getVirtualNetworksVisualizationViewersTabbedPane().repaint();
        this.getFrame().getNetworksPanel().getSdnNetworksViewersTabbedPane().repaint();
    }

    private void setFalseSelectedSdnNetworks() {
        List<SdnNetwork> sdnNetworks = this.getFrame().getSimulator().getSdnNetworks();
        int i = 0;
        while (i < sdnNetworks.size()) {
            SdnNetwork sdnNetwork = sdnNetworks.get(i);
            for (SdnNode sdnNode : sdnNetwork.getSdnNodes()) {
                sdnNode.setSelected(false);
            }
            for (SdnLink sdnLink : sdnNetwork.getSdnLinks()) {
                sdnLink.setSelected(false);
            }
            ++i;
        }
    }

    private void setFalseSelectedVirtualNetworks() {
        List<VirtualNetwork> virtualNetworks = this.getFrame().getSimulator().getVirtualNetworks();
        int i = 0;
        while (i < virtualNetworks.size()) {
            VirtualNetwork virtualNetwork = virtualNetworks.get(i);
            for (VirtualNode virtualNode : virtualNetwork.getVirtualNodes()) {
                virtualNode.setSelected(false);
            }
            for (VirtualLink virtualLink : virtualNetwork.getVirtualLinks()) {
                virtualLink.setSelected(false);
            }
            ++i;
        }
    }
}

