/*
 * Decompiled with CFR 0.152.
 */
package frame.networks.viewers;

import edu.uci.ics.jung.algorithms.layout.CircleLayout;
import frame.SimulatorFrame;
import frame.networks.viewers.viewer.NetworkVisualizationViewer;
import java.awt.BorderLayout;
import java.awt.Color;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import model.components.links.link.Link;
import model.components.networks.sdn.SdnNetwork;
import model.components.nodes.comparator.NodeNumberComparator;
import model.components.nodes.node.Node;

public class SdnVisualizationViewersTabbedPane
extends JTabbedPane {
    private SimulatorFrame simulatorFrame;

    public SimulatorFrame getFrame() {
        return this.simulatorFrame;
    }

    public void setFrame(SimulatorFrame simulatorFrame) {
        this.simulatorFrame = simulatorFrame;
    }

    public SdnVisualizationViewersTabbedPane(SimulatorFrame simulatorFrame) {
        this.setFrame(simulatorFrame);
        this.setTabPlacement(1);
        for (SdnNetwork sdnNetwork : simulatorFrame.getSimulator().getSdnNetworks()) {
            this.addSdnNetworkTab(sdnNetwork);
        }
    }

    public void addSdnNetworkTab(SdnNetwork sdnNetwork) {
        CircleLayout<Node, Link> circleLayout = new CircleLayout<Node, Link>(sdnNetwork.getGraph());
        circleLayout.setVertexOrder(new NodeNumberComparator());
        NetworkVisualizationViewer networkVisualizationViewer = new NetworkVisualizationViewer(circleLayout, this.getFrame());
        networkVisualizationViewer.setBackground(Color.WHITE);
        JPanel panel = new JPanel(new BorderLayout());
        panel.add(networkVisualizationViewer);
        this.addTab(sdnNetwork.getName(), null, panel, "SDN network " + sdnNetwork.getNumber());
    }
}

