/*
 * Decompiled with CFR 0.152.
 */
package frame.networks.tables.virtual;

import frame.SimulatorFrame;
import frame.networks.tables.TableCellRenderer;
import frame.networks.tables.virtual.VirtualTableModel;
import frame.networks.viewers.VirtualVisualizationViewersTabbedPane;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.List;
import javax.swing.JTable;
import model.components.networks.virtual.VirtualNetwork;

public class VirtualTable
extends JTable
implements MouseListener {
    private List<VirtualNetwork> virtualNetworks;
    private SimulatorFrame simulatorFrame;

    public List<VirtualNetwork> getVirtualNetworks() {
        return this.virtualNetworks;
    }

    public void setVirtualNetworks(List<VirtualNetwork> virtualNetworks) {
        this.virtualNetworks = virtualNetworks;
    }

    public SimulatorFrame getFrame() {
        return this.simulatorFrame;
    }

    public void setFrame(SimulatorFrame simulatorFrame) {
        this.simulatorFrame = simulatorFrame;
    }

    public VirtualTable(List<VirtualNetwork> virtualNetworks, SimulatorFrame simulatorFrame) {
        this.setVirtualNetworks(virtualNetworks);
        this.setFrame(simulatorFrame);
        VirtualTableModel virtualTableModel = new VirtualTableModel(new String[]{"Networks", "Start", "End", "State"}, 0, virtualNetworks);
        for (VirtualNetwork virtualNetwork : this.getVirtualNetworks()) {
            virtualTableModel.addRow(new Object[]{virtualNetwork.getName(), virtualNetwork.getStartingDate(), virtualNetwork.getEndingDate(), virtualNetwork.getState()});
        }
        this.setModel(virtualTableModel);
        this.setDefaultRenderer(Object.class, new TableCellRenderer());
        this.setSelectionMode(0);
        this.addMouseListener(this);
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        int selectedRowIndex = ((JTable)mouseEvent.getSource()).getSelectedRow();
        String virtualNetworkName = (String)this.getModel().getValueAt(selectedRowIndex, 0);
        for (VirtualNetwork virtualNetwork : this.getVirtualNetworks()) {
            if (!virtualNetwork.getName().equals(virtualNetworkName)) continue;
            VirtualVisualizationViewersTabbedPane virtualVisualizationViewersTabbedPane = this.getFrame().getNetworksPanel().getVirtualNetworksVisualizationViewersTabbedPane();
            virtualVisualizationViewersTabbedPane.setSelectedIndex(virtualVisualizationViewersTabbedPane.indexOfTab(virtualNetwork.getName()));
            break;
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }
}

