/*
 * Decompiled with CFR 0.152.
 */
package frame.networks.tables.sdn;

import frame.SimulatorFrame;
import frame.networks.tables.TableCellRenderer;
import frame.networks.tables.sdn.SdnTableModel;
import frame.networks.viewers.SdnVisualizationViewersTabbedPane;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.List;
import javax.swing.JTable;
import model.components.networks.sdn.SdnNetwork;

public class SdnTable
extends JTable
implements MouseListener {
    private List<SdnNetwork> sdnNetworks;
    private SimulatorFrame simulatorFrame;

    public List<SdnNetwork> getSdnNetworks() {
        return this.sdnNetworks;
    }

    public void setSdnNetworks(List<SdnNetwork> sdnNetworks) {
        this.sdnNetworks = sdnNetworks;
    }

    public SimulatorFrame getFrame() {
        return this.simulatorFrame;
    }

    public void setFrame(SimulatorFrame simulatorFrame) {
        this.simulatorFrame = simulatorFrame;
    }

    public SdnTable(List<SdnNetwork> sdnNetworks, SimulatorFrame simulatorFrame) {
        this.setSdnNetworks(sdnNetworks);
        this.setFrame(simulatorFrame);
        SdnTableModel sdnTableModel = new SdnTableModel(new String[]{"Networks", "State"}, 0, sdnNetworks);
        for (SdnNetwork sdnNetwork : this.getSdnNetworks()) {
            sdnTableModel.addRow(new Object[]{sdnNetwork.getName(), sdnNetwork.getState()});
        }
        this.setModel(sdnTableModel);
        this.setDefaultRenderer(Object.class, new TableCellRenderer());
        this.setSelectionMode(0);
        this.addMouseListener(this);
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        int selectedRowIndex = ((JTable)mouseEvent.getSource()).getSelectedRow();
        String sdnNetworkName = (String)this.getModel().getValueAt(selectedRowIndex, 0);
        for (SdnNetwork sdnNetwork : this.getSdnNetworks()) {
            if (!sdnNetwork.getName().equals(sdnNetworkName)) continue;
            SdnVisualizationViewersTabbedPane sdnVisualizationViewersTabbedPane = this.getFrame().getNetworksPanel().getSdnNetworksViewersTabbedPane();
            sdnVisualizationViewersTabbedPane.setSelectedIndex(sdnVisualizationViewersTabbedPane.indexOfTab(sdnNetwork.getName()));
            break;
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }
}

