/*
 * Decompiled with CFR 0.152.
 */
package frame.networks.tables;

import frame.SimulatorFrame;
import frame.networks.tables.sdn.SdnTable;
import frame.networks.tables.virtual.VirtualTable;
import java.awt.Dimension;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.List;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import model.components.networks.sdn.SdnNetwork;
import model.components.networks.virtual.VirtualNetwork;

public class NetworksTableTabbedPane
extends JTabbedPane
implements MouseListener {
    private SimulatorFrame simulatorFrame;
    private SdnTable sdnTable;
    private VirtualTable virtualTable;

    public SimulatorFrame getFrame() {
        return this.simulatorFrame;
    }

    public void setFrame(SimulatorFrame simulatorFrame) {
        this.simulatorFrame = simulatorFrame;
    }

    public SdnTable getSdnNetworksTable() {
        return this.sdnTable;
    }

    public void setSdnNetworksTable(SdnTable sdnTable) {
        this.sdnTable = sdnTable;
    }

    public VirtualTable getVirtualNetworksTable() {
        return this.virtualTable;
    }

    public void setVirtualNetworksTable(VirtualTable virtualTable) {
        this.virtualTable = virtualTable;
    }

    public NetworksTableTabbedPane(List<SdnNetwork> sdnNetworks, List<VirtualNetwork> virtualNetworks, SimulatorFrame simulatorFrame) {
        this.setFrame(simulatorFrame);
        this.setSdnNetworksTable(new SdnTable(sdnNetworks, this.getFrame()));
        this.setVirtualNetworksTable(new VirtualTable(virtualNetworks, this.getFrame()));
        this.setTabPlacement(1);
        this.setPreferredSize(new Dimension(200, 10));
        this.addTab("SDN", null, new JScrollPane(this.getSdnNetworksTable()), null);
        this.addTab("Virtual", null, new JScrollPane(this.getVirtualNetworksTable()), null);
        this.addMouseListener(this);
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        JSplitPane splitPane = this.getFrame().getNetworksPanel().getSplitPane();
        if (this.getSelectedIndex() == 0) {
            splitPane.setRightComponent(this.getFrame().getNetworksPanel().getSdnNetworksViewersTabbedPane());
        } else if (this.getSelectedIndex() == 1) {
            splitPane.setRightComponent(this.getFrame().getNetworksPanel().getVirtualNetworksVisualizationViewersTabbedPane());
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }
}

