/*
 * Decompiled with CFR 0.152.
 */
package com.nexes.wizard;

import com.nexes.wizard.WizardPanelDescriptor;
import com.nexes.wizard.WizardPanelNotFoundException;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.HashMap;
import javax.swing.Icon;

public class WizardModel {
    public static final String CURRENT_PANEL_DESCRIPTOR_PROPERTY = "currentPanelDescriptorProperty";
    public static final String BACK_BUTTON_TEXT_PROPERTY = "backButtonTextProperty";
    public static final String BACK_BUTTON_ICON_PROPERTY = "backButtonIconProperty";
    public static final String BACK_BUTTON_ENABLED_PROPERTY = "backButtonEnabledProperty";
    public static final String NEXT_FINISH_BUTTON_TEXT_PROPERTY = "nextButtonTextProperty";
    public static final String NEXT_FINISH_BUTTON_ICON_PROPERTY = "nextButtonIconProperty";
    public static final String NEXT_FINISH_BUTTON_ENABLED_PROPERTY = "nextButtonEnabledProperty";
    public static final String CANCEL_BUTTON_TEXT_PROPERTY = "cancelButtonTextProperty";
    public static final String CANCEL_BUTTON_ICON_PROPERTY = "cancelButtonIconProperty";
    public static final String CANCEL_BUTTON_ENABLED_PROPERTY = "cancelButtonEnabledProperty";
    private WizardPanelDescriptor currentPanel;
    private HashMap panelHashmap = new HashMap();
    private HashMap buttonTextHashmap = new HashMap();
    private HashMap buttonIconHashmap = new HashMap();
    private HashMap buttonEnabledHashmap = new HashMap();
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

    WizardPanelDescriptor getCurrentPanelDescriptor() {
        return this.currentPanel;
    }

    void registerPanel(Object id, WizardPanelDescriptor descriptor) {
        this.panelHashmap.put(id, descriptor);
    }

    boolean setCurrentPanel(Object id) {
        WizardPanelDescriptor nextPanel = (WizardPanelDescriptor)this.panelHashmap.get(id);
        if (nextPanel == null) {
            throw new WizardPanelNotFoundException();
        }
        WizardPanelDescriptor oldPanel = this.currentPanel;
        this.currentPanel = nextPanel;
        if (oldPanel != this.currentPanel) {
            this.firePropertyChange(CURRENT_PANEL_DESCRIPTOR_PROPERTY, oldPanel, this.currentPanel);
        }
        return true;
    }

    Object getBackButtonText() {
        return this.buttonTextHashmap.get(BACK_BUTTON_TEXT_PROPERTY);
    }

    void setBackButtonText(Object newText) {
        Object oldText = this.getBackButtonText();
        if (!newText.equals(oldText)) {
            this.buttonTextHashmap.put(BACK_BUTTON_TEXT_PROPERTY, newText);
            this.firePropertyChange(BACK_BUTTON_TEXT_PROPERTY, oldText, newText);
        }
    }

    Object getNextFinishButtonText() {
        return this.buttonTextHashmap.get(NEXT_FINISH_BUTTON_TEXT_PROPERTY);
    }

    void setNextFinishButtonText(Object newText) {
        Object oldText = this.getNextFinishButtonText();
        if (!newText.equals(oldText)) {
            this.buttonTextHashmap.put(NEXT_FINISH_BUTTON_TEXT_PROPERTY, newText);
            this.firePropertyChange(NEXT_FINISH_BUTTON_TEXT_PROPERTY, oldText, newText);
        }
    }

    Object getCancelButtonText() {
        return this.buttonTextHashmap.get(CANCEL_BUTTON_TEXT_PROPERTY);
    }

    void setCancelButtonText(Object newText) {
        Object oldText = this.getCancelButtonText();
        if (!newText.equals(oldText)) {
            this.buttonTextHashmap.put(CANCEL_BUTTON_TEXT_PROPERTY, newText);
            this.firePropertyChange(CANCEL_BUTTON_TEXT_PROPERTY, oldText, newText);
        }
    }

    Icon getBackButtonIcon() {
        return (Icon)this.buttonIconHashmap.get(BACK_BUTTON_ICON_PROPERTY);
    }

    void setBackButtonIcon(Icon newIcon) {
        Icon oldIcon = this.getBackButtonIcon();
        if (!newIcon.equals(oldIcon)) {
            this.buttonIconHashmap.put(BACK_BUTTON_ICON_PROPERTY, newIcon);
            this.firePropertyChange(BACK_BUTTON_ICON_PROPERTY, oldIcon, newIcon);
        }
    }

    Icon getNextFinishButtonIcon() {
        return (Icon)this.buttonIconHashmap.get(NEXT_FINISH_BUTTON_ICON_PROPERTY);
    }

    public void setNextFinishButtonIcon(Icon newIcon) {
        Icon oldIcon = this.getNextFinishButtonIcon();
        if (!newIcon.equals(oldIcon)) {
            this.buttonIconHashmap.put(NEXT_FINISH_BUTTON_ICON_PROPERTY, newIcon);
            this.firePropertyChange(NEXT_FINISH_BUTTON_ICON_PROPERTY, oldIcon, newIcon);
        }
    }

    Icon getCancelButtonIcon() {
        return (Icon)this.buttonIconHashmap.get(CANCEL_BUTTON_ICON_PROPERTY);
    }

    void setCancelButtonIcon(Icon newIcon) {
        Icon oldIcon = this.getCancelButtonIcon();
        if (!newIcon.equals(oldIcon)) {
            this.buttonIconHashmap.put(CANCEL_BUTTON_ICON_PROPERTY, newIcon);
            this.firePropertyChange(CANCEL_BUTTON_ICON_PROPERTY, oldIcon, newIcon);
        }
    }

    Boolean getBackButtonEnabled() {
        return (Boolean)this.buttonEnabledHashmap.get(BACK_BUTTON_ENABLED_PROPERTY);
    }

    void setBackButtonEnabled(Boolean newValue) {
        Boolean oldValue = this.getBackButtonEnabled();
        if (newValue != oldValue) {
            this.buttonEnabledHashmap.put(BACK_BUTTON_ENABLED_PROPERTY, newValue);
            this.firePropertyChange(BACK_BUTTON_ENABLED_PROPERTY, oldValue, newValue);
        }
    }

    Boolean getNextFinishButtonEnabled() {
        return (Boolean)this.buttonEnabledHashmap.get(NEXT_FINISH_BUTTON_ENABLED_PROPERTY);
    }

    void setNextFinishButtonEnabled(Boolean newValue) {
        Boolean oldValue = this.getNextFinishButtonEnabled();
        if (newValue != oldValue) {
            this.buttonEnabledHashmap.put(NEXT_FINISH_BUTTON_ENABLED_PROPERTY, newValue);
            this.firePropertyChange(NEXT_FINISH_BUTTON_ENABLED_PROPERTY, oldValue, newValue);
        }
    }

    Boolean getCancelButtonEnabled() {
        return (Boolean)this.buttonEnabledHashmap.get(CANCEL_BUTTON_ENABLED_PROPERTY);
    }

    void setCancelButtonEnabled(Boolean newValue) {
        Boolean oldValue = this.getCancelButtonEnabled();
        if (newValue != oldValue) {
            this.buttonEnabledHashmap.put(CANCEL_BUTTON_ENABLED_PROPERTY, newValue);
            this.firePropertyChange(CANCEL_BUTTON_ENABLED_PROPERTY, oldValue, newValue);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener p) {
        this.propertyChangeSupport.addPropertyChangeListener(p);
    }

    public void removePropertyChangeListener(PropertyChangeListener p) {
        this.propertyChangeSupport.removePropertyChangeListener(p);
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        this.propertyChangeSupport.firePropertyChange(propertyName, oldValue, newValue);
    }
}

